/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.encryption;

import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.avro.GenericAvroReader;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.avro.RawDecoder;
import com.dataiku.dss.shadelib.org.apache.iceberg.encryption.StandardKeyMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.MapMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.avro.message.MessageDecoder;

class KeyMetadataDecoder
extends MessageDecoder.BaseDecoder<StandardKeyMetadata> {
    private final Schema readSchema;
    private final Map<Byte, RawDecoder<StandardKeyMetadata>> decoders = new MapMaker().makeMap();

    KeyMetadataDecoder(byte readSchemaVersion) {
        this.readSchema = StandardKeyMetadata.supportedSchemaVersions().get(readSchemaVersion);
    }

    public StandardKeyMetadata decode(InputStream stream, StandardKeyMetadata reuse) {
        byte writeSchemaVersion;
        try {
            writeSchemaVersion = (byte)stream.read();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read the version byte", e);
        }
        if (writeSchemaVersion < 0) {
            throw new RuntimeException("Version byte - end of stream reached");
        }
        org.apache.avro.Schema writeSchema = StandardKeyMetadata.supportedAvroSchemaVersions().get(writeSchemaVersion);
        if (writeSchema == null) {
            throw new UnsupportedOperationException("Cannot resolve schema for version: " + writeSchemaVersion);
        }
        RawDecoder<StandardKeyMetadata> decoder = this.decoders.get(writeSchemaVersion);
        if (decoder == null) {
            decoder = RawDecoder.create(this.readSchema, GenericAvroReader::create, writeSchema);
            this.decoders.put(writeSchemaVersion, decoder);
        }
        return decoder.decode(stream, reuse);
    }
}

