/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.expressions;

import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.And;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.ExpressionVisitors;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.False;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literal;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Literals;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.NamedReference;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Not;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Or;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.RewriteNot;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.True;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundAggregate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundExtract;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundPredicate;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundTerm;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.UnboundTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Lists;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transforms;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.NaNUtil;
import java.util.stream.Stream;

public class Expressions {
    private Expressions() {
    }

    public static Expression and(Expression left, Expression right) {
        Preconditions.checkNotNull(left, "Left expression cannot be null.");
        Preconditions.checkNotNull(right, "Right expression cannot be null.");
        if (left == Expressions.alwaysFalse() || right == Expressions.alwaysFalse()) {
            return Expressions.alwaysFalse();
        }
        if (left == Expressions.alwaysTrue()) {
            return right;
        }
        if (right == Expressions.alwaysTrue()) {
            return left;
        }
        return new And(left, right);
    }

    public static Expression and(Expression left, Expression right, Expression ... expressions) {
        return Stream.of(expressions).reduce(Expressions.and(left, right), Expressions::and);
    }

    public static Expression or(Expression left, Expression right) {
        Preconditions.checkNotNull(left, "Left expression cannot be null.");
        Preconditions.checkNotNull(right, "Right expression cannot be null.");
        if (left == Expressions.alwaysTrue() || right == Expressions.alwaysTrue()) {
            return Expressions.alwaysTrue();
        }
        if (left == Expressions.alwaysFalse()) {
            return right;
        }
        if (right == Expressions.alwaysFalse()) {
            return left;
        }
        return new Or(left, right);
    }

    public static Expression not(Expression child) {
        Preconditions.checkNotNull(child, "Child expression cannot be null.");
        if (child == Expressions.alwaysTrue()) {
            return Expressions.alwaysFalse();
        }
        if (child == Expressions.alwaysFalse()) {
            return Expressions.alwaysTrue();
        }
        if (child instanceof Not) {
            return ((Not)child).child();
        }
        return new Not(child);
    }

    public static <T> UnboundTerm<T> bucket(String name, int numBuckets) {
        Transform transform = Transforms.bucket(numBuckets);
        return new UnboundTransform<T, Integer>(Expressions.ref(name), transform);
    }

    public static <T> UnboundTerm<T> year(String name) {
        return new UnboundTransform<T, Integer>(Expressions.ref(name), Transforms.year());
    }

    public static <T> UnboundTerm<T> month(String name) {
        return new UnboundTransform<T, Integer>(Expressions.ref(name), Transforms.month());
    }

    public static <T> UnboundTerm<T> day(String name) {
        return new UnboundTransform<T, Integer>(Expressions.ref(name), Transforms.day());
    }

    public static <T> UnboundTerm<T> hour(String name) {
        return new UnboundTransform<T, Integer>(Expressions.ref(name), Transforms.hour());
    }

    public static <T> UnboundTerm<T> truncate(String name, int width) {
        return new UnboundTransform(Expressions.ref(name), Transforms.truncate(width));
    }

    public static <T> UnboundTerm<T> extract(String name, String path, String type) {
        return new UnboundExtract(Expressions.ref(name), path, type);
    }

    public static <T> UnboundPredicate<T> isNull(String name) {
        return new UnboundPredicate<T>(Expression.Operation.IS_NULL, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> isNull(UnboundTerm<T> expr) {
        return new UnboundPredicate<T>(Expression.Operation.IS_NULL, expr);
    }

    public static <T> UnboundPredicate<T> notNull(String name) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_NULL, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> notNull(UnboundTerm<T> expr) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_NULL, expr);
    }

    public static <T> UnboundPredicate<T> isNaN(String name) {
        return new UnboundPredicate<T>(Expression.Operation.IS_NAN, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> isNaN(UnboundTerm<T> expr) {
        return new UnboundPredicate<T>(Expression.Operation.IS_NAN, expr);
    }

    public static <T> UnboundPredicate<T> notNaN(String name) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_NAN, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> notNaN(UnboundTerm<T> expr) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_NAN, expr);
    }

    public static <T> UnboundPredicate<T> lessThan(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> lessThan(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT, expr, value);
    }

    public static <T> UnboundPredicate<T> lessThanOrEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> lessThanOrEqual(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.LT_EQ, expr, value);
    }

    public static <T> UnboundPredicate<T> greaterThan(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> greaterThan(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT, expr, value);
    }

    public static <T> UnboundPredicate<T> greaterThanOrEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> greaterThanOrEqual(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.GT_EQ, expr, value);
    }

    public static <T> UnboundPredicate<T> equal(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> equal(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.EQ, expr, value);
    }

    public static <T> UnboundPredicate<T> notEqual(String name, T value) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_EQ, Expressions.ref(name), value);
    }

    public static <T> UnboundPredicate<T> notEqual(UnboundTerm<T> expr, T value) {
        return new UnboundPredicate<T>(Expression.Operation.NOT_EQ, expr, value);
    }

    public static UnboundPredicate<String> startsWith(String name, String value) {
        return new UnboundPredicate<String>(Expression.Operation.STARTS_WITH, Expressions.ref(name), value);
    }

    public static UnboundPredicate<String> startsWith(UnboundTerm<String> expr, String value) {
        return new UnboundPredicate<String>(Expression.Operation.STARTS_WITH, expr, value);
    }

    public static UnboundPredicate<String> notStartsWith(String name, String value) {
        return new UnboundPredicate<String>(Expression.Operation.NOT_STARTS_WITH, Expressions.ref(name), value);
    }

    public static UnboundPredicate<String> notStartsWith(UnboundTerm<String> expr, String value) {
        return new UnboundPredicate<String>(Expression.Operation.NOT_STARTS_WITH, expr, value);
    }

    public static <T> UnboundPredicate<T> in(String name, T ... values2) {
        return Expressions.predicate(Expression.Operation.IN, name, Lists.newArrayList(values2));
    }

    public static <T> UnboundPredicate<T> in(UnboundTerm<T> expr, T ... values2) {
        return Expressions.predicate(Expression.Operation.IN, expr, Lists.newArrayList(values2));
    }

    public static <T> UnboundPredicate<T> in(String name, Iterable<T> values2) {
        Preconditions.checkNotNull(values2, "Values cannot be null for IN predicate.");
        return Expressions.predicate(Expression.Operation.IN, Expressions.ref(name), values2);
    }

    public static <T> UnboundPredicate<T> in(UnboundTerm<T> expr, Iterable<T> values2) {
        Preconditions.checkNotNull(values2, "Values cannot be null for IN predicate.");
        return Expressions.predicate(Expression.Operation.IN, expr, values2);
    }

    public static <T> UnboundPredicate<T> notIn(String name, T ... values2) {
        return Expressions.predicate(Expression.Operation.NOT_IN, name, Lists.newArrayList(values2));
    }

    public static <T> UnboundPredicate<T> notIn(UnboundTerm<T> expr, T ... values2) {
        return Expressions.predicate(Expression.Operation.NOT_IN, expr, Lists.newArrayList(values2));
    }

    public static <T> UnboundPredicate<T> notIn(String name, Iterable<T> values2) {
        Preconditions.checkNotNull(values2, "Values cannot be null for NOT_IN predicate.");
        return Expressions.predicate(Expression.Operation.NOT_IN, name, values2);
    }

    public static <T> UnboundPredicate<T> notIn(UnboundTerm<T> expr, Iterable<T> values2) {
        Preconditions.checkNotNull(values2, "Values cannot be null for NOT_IN predicate.");
        return Expressions.predicate(Expression.Operation.NOT_IN, expr, values2);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name, T value) {
        return Expressions.predicate(op, name, Literals.from(value));
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name, Literal<T> lit) {
        Preconditions.checkArgument(op != Expression.Operation.IS_NULL && op != Expression.Operation.NOT_NULL && op != Expression.Operation.IS_NAN && op != Expression.Operation.NOT_NAN, "Cannot create %s predicate inclusive a value", (Object)op);
        Preconditions.checkArgument(!NaNUtil.isNaN(lit.value()), "Invalid expression literal: NaN, use isNaN or notNaN instead");
        return new UnboundPredicate<T>(op, Expressions.ref(name), lit);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name, Iterable<T> values2) {
        return Expressions.predicate(op, Expressions.ref(name), values2);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, String name) {
        Preconditions.checkArgument(op == Expression.Operation.IS_NULL || op == Expression.Operation.NOT_NULL || op == Expression.Operation.IS_NAN || op == Expression.Operation.NOT_NAN, "Cannot create %s predicate without a value", (Object)op);
        return new UnboundPredicate<T>(op, Expressions.ref(name));
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, UnboundTerm<T> expr, Iterable<T> values2) {
        return new UnboundPredicate<T>(op, expr, values2);
    }

    public static <T> UnboundPredicate<T> predicate(Expression.Operation op, UnboundTerm<T> expr) {
        return new UnboundPredicate<T>(op, expr);
    }

    public static True alwaysTrue() {
        return True.INSTANCE;
    }

    public static False alwaysFalse() {
        return False.INSTANCE;
    }

    public static Expression rewriteNot(Expression expr) {
        return ExpressionVisitors.visit(expr, RewriteNot.get());
    }

    public static <T> NamedReference<T> ref(String name) {
        return new NamedReference(name);
    }

    public static <T> UnboundTerm<T> transform(String name, Transform<?, T> transform) {
        return new UnboundTransform<T, T>(Expressions.ref(name), transform);
    }

    public static <T> Literal<T> lit(T value) {
        return Literals.from(value);
    }

    public static Literal<Long> micros(long micros) {
        return new Literals.TimestampLiteral(micros);
    }

    public static Literal<Long> millis(long millis) {
        return new Literals.TimestampLiteral(millis * 1000L);
    }

    public static Literal<Long> nanos(long nanos) {
        return new Literals.TimestampNanoLiteral(nanos);
    }

    public static <T> UnboundAggregate<T> count(String name) {
        return new UnboundAggregate<T>(Expression.Operation.COUNT, Expressions.ref(name));
    }

    public static <T> UnboundAggregate<T> countStar() {
        return new UnboundAggregate(Expression.Operation.COUNT_STAR, null);
    }

    public static <T> UnboundAggregate<T> max(String name) {
        return new UnboundAggregate<T>(Expression.Operation.MAX, Expressions.ref(name));
    }

    public static <T> UnboundAggregate<T> min(String name) {
        return new UnboundAggregate<T>(Expression.Operation.MIN, Expressions.ref(name));
    }
}

