/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.jdbc;

import com.dataiku.dss.shadelib.org.apache.iceberg.ClientPoolImpl;
import com.dataiku.dss.shadelib.org.apache.iceberg.jdbc.JdbcUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.jdbc.UncheckedSQLException;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class JdbcClientPool
extends ClientPoolImpl<Connection, SQLException> {
    static final Set<String> COMMON_RETRYABLE_CONNECTION_SQL_STATES = ImmutableSet.of("08000", "08003", "08006", "08007", "40001");
    private final String dbUrl;
    private final Map<String, String> properties;
    private final Set<String> retryableStatusCodes;

    public JdbcClientPool(String dbUrl, Map<String, String> props) {
        this(Integer.parseInt(props.getOrDefault("clients", String.valueOf(2))), dbUrl, props);
    }

    public JdbcClientPool(int poolSize, String dbUrl, Map<String, String> props) {
        super(poolSize, SQLTransientException.class, true);
        this.properties = props;
        this.retryableStatusCodes = Sets.newHashSet();
        this.retryableStatusCodes.addAll(COMMON_RETRYABLE_CONNECTION_SQL_STATES);
        String configuredRetryableStatuses = props.get("retryable_status_codes");
        if (configuredRetryableStatuses != null) {
            this.retryableStatusCodes.addAll(Arrays.stream(configuredRetryableStatuses.split(",")).map(status -> status.replaceAll("\\s+", "")).collect(Collectors.toSet()));
        }
        this.dbUrl = dbUrl;
    }

    @Override
    protected Connection newClient() {
        try {
            Properties dbProps = JdbcUtil.filterAndRemovePrefix(this.properties, "jdbc.");
            return DriverManager.getConnection(this.dbUrl, dbProps);
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to connect: %s", this.dbUrl);
        }
    }

    @Override
    protected Connection reconnect(Connection client) {
        this.close(client);
        return this.newClient();
    }

    @Override
    protected void close(Connection client) {
        try {
            client.close();
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to close connection", new Object[0]);
        }
    }

    @Override
    protected boolean isConnectionException(Exception e) {
        return super.isConnectionException(e) || e instanceof SQLException && this.retryableStatusCodes.contains(((SQLException)e).getSQLState());
    }
}

