/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.metrics;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.CounterResult;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import java.io.IOException;

class CounterResultParser {
    private static final String MISSING_FIELD_ERROR_MSG = "Cannot parse counter from '%s': Missing field '%s'";
    private static final String UNIT = "unit";
    private static final String VALUE = "value";

    private CounterResultParser() {
    }

    static String toJson(CounterResult counter) {
        return CounterResultParser.toJson(counter, false);
    }

    static String toJson(CounterResult counter, boolean pretty) {
        return JsonUtil.generate(gen -> CounterResultParser.toJson(counter, gen), pretty);
    }

    static void toJson(CounterResult counter, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != counter, "Invalid counter: null");
        gen.writeStartObject();
        gen.writeStringField(UNIT, counter.unit().displayName());
        gen.writeNumberField(VALUE, counter.value());
        gen.writeEndObject();
    }

    static CounterResult fromJson(String json) {
        return JsonUtil.parse(json, CounterResultParser::fromJson);
    }

    static CounterResult fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse counter from null object");
        Preconditions.checkArgument(json.isObject(), "Cannot parse counter from non-object: %s", (Object)json);
        String unit = JsonUtil.getString(UNIT, json);
        long value = JsonUtil.getLong(VALUE, json);
        return CounterResult.of(MetricsContext.Unit.fromDisplayName(unit), value);
    }

    static CounterResult fromJson(String counterName, JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse counter from null object");
        Preconditions.checkArgument(json.isObject(), "Cannot parse counter from non-object: %s", (Object)json);
        if (!json.has(counterName)) {
            return null;
        }
        JsonNode counter = json.get(counterName);
        Preconditions.checkArgument(counter.has(UNIT), MISSING_FIELD_ERROR_MSG, (Object)counterName, (Object)UNIT);
        Preconditions.checkArgument(counter.has(VALUE), MISSING_FIELD_ERROR_MSG, (Object)counterName, (Object)VALUE);
        String unit = JsonUtil.getString(UNIT, counter);
        long value = JsonUtil.getLong(VALUE, counter);
        return CounterResult.of(MetricsContext.Unit.fromDisplayName(unit), value);
    }
}

