/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.metrics;

import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Counter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;

public class DefaultCounter
implements Counter {
    public static final Counter NOOP = new DefaultCounter(MetricsContext.Unit.UNDEFINED){

        @Override
        public void increment() {
        }

        @Override
        public void increment(long amount) {
        }

        @Override
        public long value() {
            throw new UnsupportedOperationException("NOOP counter has no value");
        }

        @Override
        public String toString() {
            return "NOOP counter";
        }
    };
    private final LongAdder counter;
    private final MetricsContext.Unit unit;
    private AsIntCounter asIntCounter = null;
    private AsLongCounter asLongCounter = null;

    DefaultCounter(MetricsContext.Unit unit) {
        Preconditions.checkArgument(null != unit, "Invalid count unit: null");
        this.unit = unit;
        this.counter = new LongAdder();
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void increment(long amount) {
        this.counter.add(amount);
    }

    @Override
    public long value() {
        return this.counter.longValue();
    }

    public String toString() {
        return String.format("{%s=%s}", this.unit().displayName(), this.value());
    }

    @Override
    public MetricsContext.Unit unit() {
        return this.unit;
    }

    MetricsContext.Counter<Integer> asIntCounter() {
        if (null == this.asIntCounter) {
            this.asIntCounter = new AsIntCounter();
        }
        return this.asIntCounter;
    }

    MetricsContext.Counter<Long> asLongCounter() {
        if (null == this.asLongCounter) {
            this.asLongCounter = new AsLongCounter();
        }
        return this.asLongCounter;
    }

    private class AsIntCounter
    implements MetricsContext.Counter<Integer> {
        private AsIntCounter() {
        }

        @Override
        public void increment() {
            this.increment(1);
        }

        @Override
        public void increment(Integer amount) {
            DefaultCounter.this.increment(amount);
        }

        @Override
        public Optional<Integer> count() {
            return Optional.of(this.value());
        }

        @Override
        public Integer value() {
            long value = DefaultCounter.this.counter.longValue();
            if (value > Integer.MAX_VALUE) {
                throw new ArithmeticException("integer overflow");
            }
            return (int)value;
        }

        @Override
        public MetricsContext.Unit unit() {
            return DefaultCounter.this.unit;
        }
    }

    private class AsLongCounter
    implements MetricsContext.Counter<Long> {
        private AsLongCounter() {
        }

        @Override
        public void increment() {
            DefaultCounter.this.increment();
        }

        @Override
        public void increment(Long amount) {
            DefaultCounter.this.increment(amount);
        }

        @Override
        public Optional<Long> count() {
            return Optional.of(this.value());
        }

        @Override
        public Long value() {
            return DefaultCounter.this.counter.longValue();
        }

        @Override
        public MetricsContext.Unit unit() {
            return DefaultCounter.this.unit;
        }
    }
}

