/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest;

import com.dataiku.dss.shadelib.org.apache.iceberg.rest.HTTPRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.ParserContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTClient;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTResponse;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.auth.AuthSession;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses.ErrorResponse;
import java.util.Map;
import java.util.function.Consumer;

public abstract class BaseHTTPClient
implements RESTClient {
    @Override
    public abstract RESTClient withAuthSession(AuthSession var1);

    @Override
    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.HEAD, path, null, headers, null);
        this.execute(request, null, errorHandler, h2 -> {});
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.DELETE, path, null, headers, null);
        return this.execute(request, responseType, errorHandler, h2 -> {});
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.DELETE, path, queryParams, headers, null);
        return this.execute(request, responseType, errorHandler, h2 -> {});
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.GET, path, queryParams, headers, null);
        return this.execute(request, responseType, errorHandler, h2 -> {});
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, ParserContext parserContext) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.GET, path, queryParams, headers, null);
        return this.execute(request, responseType, errorHandler, h2 -> {}, parserContext);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.POST, path, null, headers, body);
        return this.execute(request, responseType, errorHandler, h2 -> {});
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.POST, path, null, headers, body);
        return this.execute(request, responseType, errorHandler, responseHeaders);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders, ParserContext parserContext) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.POST, path, null, headers, body);
        return this.execute(request, responseType, errorHandler, responseHeaders, parserContext);
    }

    @Override
    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        HTTPRequest request = this.buildRequest(HTTPRequest.HTTPMethod.POST, path, null, headers, formData);
        return this.execute(request, responseType, errorHandler, h2 -> {});
    }

    protected abstract HTTPRequest buildRequest(HTTPRequest.HTTPMethod var1, String var2, Map<String, String> var3, Map<String, String> var4, Object var5);

    protected abstract <T extends RESTResponse> T execute(HTTPRequest var1, Class<T> var2, Consumer<ErrorResponse> var3, Consumer<Map<String, String>> var4);

    protected <T extends RESTResponse> T execute(HTTPRequest request, Class<T> responseType, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders, ParserContext parserContext) {
        if (null != parserContext) {
            throw new UnsupportedOperationException("Parser context is not supported");
        }
        return this.execute(request, responseType, errorHandler, responseHeaders);
    }
}

