/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.requests;

import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTRequest;
import java.util.Map;
import java.util.Objects;

public class CreateNamespaceRequest
implements RESTRequest {
    private Namespace namespace;
    private Map<String, String> properties;

    public CreateNamespaceRequest() {
    }

    private CreateNamespaceRequest(Namespace namespace, Map<String, String> properties) {
        this.namespace = namespace;
        this.properties = properties;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.namespace != null, "Invalid namespace: null");
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public Map<String, String> properties() {
        return this.properties != null ? this.properties : ImmutableMap.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("namespace", this.namespace).add("properties", this.properties).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Namespace namespace;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        public Builder withNamespace(Namespace ns) {
            Preconditions.checkNotNull(ns, "Invalid namespace: null");
            this.namespace = ns;
            return this;
        }

        public Builder setProperties(Map<String, String> props) {
            Preconditions.checkNotNull(props, "Invalid collection of properties: null");
            Preconditions.checkArgument(!props.containsKey(null), "Invalid property: null");
            Preconditions.checkArgument(!props.containsValue(null), "Invalid value for properties %s: null", Maps.filterValues(props, Objects::isNull).keySet());
            this.properties.putAll(props);
            return this;
        }

        public CreateNamespaceRequest build() {
            return new CreateNamespaceRequest(this.namespace, this.properties.build());
        }
    }
}

