/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.rest.responses;

import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.rest.RESTResponse;
import java.util.List;
import java.util.Map;

public abstract class BaseScanTaskResponse
implements RESTResponse {
    private final List<String> planTasks;
    private final List<FileScanTask> fileScanTasks;
    private final List<DeleteFile> deleteFiles;
    private final Map<Integer, PartitionSpec> specsById;

    protected BaseScanTaskResponse(List<String> planTasks, List<FileScanTask> fileScanTasks, List<DeleteFile> deleteFiles, Map<Integer, PartitionSpec> specsById) {
        this.planTasks = planTasks;
        this.fileScanTasks = fileScanTasks;
        this.deleteFiles = deleteFiles;
        this.specsById = specsById;
    }

    public List<String> planTasks() {
        return this.planTasks;
    }

    public List<FileScanTask> fileScanTasks() {
        return this.fileScanTasks;
    }

    public List<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    public static abstract class Builder<B extends Builder<B, R>, R extends BaseScanTaskResponse> {
        private List<String> planTasks;
        private List<FileScanTask> fileScanTasks;
        private List<DeleteFile> deleteFiles;
        private Map<Integer, PartitionSpec> specsById;

        protected Builder() {
        }

        public B self() {
            return (B)this;
        }

        public B withPlanTasks(List<String> tasks) {
            this.planTasks = tasks;
            return this.self();
        }

        public B withFileScanTasks(List<FileScanTask> tasks) {
            this.fileScanTasks = tasks;
            return this.self();
        }

        public B withDeleteFiles(List<DeleteFile> deleteFilesList) {
            this.deleteFiles = deleteFilesList;
            return this.self();
        }

        public B withSpecsById(Map<Integer, PartitionSpec> specs) {
            this.specsById = specs;
            return this.self();
        }

        public List<String> planTasks() {
            return this.planTasks;
        }

        public List<FileScanTask> fileScanTasks() {
            return this.fileScanTasks;
        }

        public List<DeleteFile> deleteFiles() {
            return this.deleteFiles;
        }

        public Map<Integer, PartitionSpec> specsById() {
            return this.specsById;
        }

        public abstract R build();
    }
}

