/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.transforms;

import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Dates;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.SerializationProxies;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TimeTransform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Timestamps;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.Transform;
import com.dataiku.dss.shadelib.org.apache.iceberg.transforms.TransformUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import java.io.ObjectStreamException;
import java.time.temporal.ChronoUnit;

public class Days<T>
extends TimeTransform<T> {
    private static final Days<?> INSTANCE = new Days();

    static <T> Days<T> get() {
        return INSTANCE;
    }

    @Override
    protected ChronoUnit granularity() {
        return ChronoUnit.DAYS;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        return Days.fromSourceType(type, Dates.DAY, Timestamps.MICROS_TO_DAY, Timestamps.NANOS_TO_DAY);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.DateType.get();
    }

    @Override
    public String toHumanString(Type alwaysDate, Integer value) {
        return value != null ? TransformUtil.humanDay(value) : "null";
    }

    public String toString() {
        return "day";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.DaysTransformProxy.get();
    }
}

