/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.variants;

import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.BasicType;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.SerializedValue;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantArray;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantMetadata;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.variants.VariantValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class SerializedArray
implements VariantArray,
SerializedValue {
    private static final int HEADER_SIZE = 1;
    private static final int OFFSET_SIZE_MASK = 12;
    private static final int OFFSET_SIZE_SHIFT = 2;
    private static final int IS_LARGE = 16;
    private final VariantMetadata metadata;
    private final ByteBuffer value;
    private final int offsetSize;
    private final int offsetListOffset;
    private final int dataOffset;
    private final VariantValue[] array;

    @VisibleForTesting
    static SerializedArray from(VariantMetadata metadata, byte[] bytes) {
        return SerializedArray.from(metadata, ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), bytes[0]);
    }

    static SerializedArray from(VariantMetadata metadata, ByteBuffer value, int header) {
        Preconditions.checkArgument(value.order() == ByteOrder.LITTLE_ENDIAN, "Unsupported byte order: big endian");
        BasicType basicType = VariantUtil.basicType(header);
        Preconditions.checkArgument(basicType == BasicType.ARRAY, "Invalid array, basic type: " + String.valueOf((Object)basicType));
        return new SerializedArray(metadata, value, header);
    }

    private SerializedArray(VariantMetadata metadata, ByteBuffer value, int header) {
        this.metadata = metadata;
        this.value = value;
        this.offsetSize = 1 + ((header & 0xC) >> 2);
        int numElementsSize = (header & 0x10) == 16 ? 4 : 1;
        int numElements = VariantUtil.readLittleEndianUnsigned(value, 1, numElementsSize);
        this.offsetListOffset = 1 + numElementsSize;
        this.dataOffset = this.offsetListOffset + (1 + numElements) * this.offsetSize;
        this.array = new VariantValue[numElements];
    }

    @Override
    public int numElements() {
        return this.array.length;
    }

    @Override
    public VariantValue get(int index) {
        if (null == this.array[index]) {
            int offset = VariantUtil.readLittleEndianUnsigned(this.value, this.offsetListOffset + this.offsetSize * index, this.offsetSize);
            int next = VariantUtil.readLittleEndianUnsigned(this.value, this.offsetListOffset + this.offsetSize * (1 + index), this.offsetSize);
            this.array[index] = VariantValue.from(this.metadata, VariantUtil.slice(this.value, this.dataOffset + offset, next - offset));
        }
        return this.array[index];
    }

    @Override
    public ByteBuffer buffer() {
        return this.value;
    }

    public String toString() {
        return VariantArray.asString(this);
    }
}

