/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.iceberg.view;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.core.JsonGenerator;
import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.JsonNode;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.JsonUtil;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ImmutableUnknownViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.SQLViewRepresentation;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.SQLViewRepresentationParser;
import com.dataiku.dss.shadelib.org.apache.iceberg.view.ViewRepresentation;
import java.io.IOException;
import java.util.Locale;

class ViewRepresentationParser {
    static final String TYPE = "type";

    private ViewRepresentationParser() {
    }

    static void toJson(ViewRepresentation representation, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(representation != null, "Invalid view representation: null");
        switch (representation.type().toLowerCase(Locale.ENGLISH)) {
            case "sql": {
                SQLViewRepresentationParser.toJson((SQLViewRepresentation)representation, generator);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Cannot serialize unsupported view representation: %s", representation.type()));
            }
        }
    }

    static String toJson(ViewRepresentation entry) {
        return JsonUtil.generate(gen -> ViewRepresentationParser.toJson(entry, gen), false);
    }

    static ViewRepresentation fromJson(String json) {
        return JsonUtil.parse(json, ViewRepresentationParser::fromJson);
    }

    static ViewRepresentation fromJson(JsonNode node) {
        String type;
        Preconditions.checkArgument(node != null, "Cannot parse view representation from null object");
        Preconditions.checkArgument(node.isObject(), "Cannot parse view representation from non-object: %s", (Object)node);
        switch (type = JsonUtil.getString(TYPE, node).toLowerCase(Locale.ENGLISH)) {
            case "sql": {
                return SQLViewRepresentationParser.fromJson(node);
            }
        }
        return ImmutableUnknownViewRepresentation.builder().type(type).build();
    }
}

