/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.packed.PackedInts;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

final class DocValuesLongHashSet
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(DocValuesLongHashSet.class);
    private static final long MISSING = Long.MIN_VALUE;
    final long[] table;
    final int mask;
    final boolean hasMissingValue;
    final int size;
    final long minValue;
    final long maxValue;

    DocValuesLongHashSet(long[] values2) {
        int tableSize = Math.toIntExact((long)values2.length * 3L / 2L);
        tableSize = 1 << PackedInts.bitsRequired(tableSize);
        assert ((long)tableSize >= (long)values2.length * 3L / 2L);
        this.table = new long[tableSize];
        Arrays.fill(this.table, Long.MIN_VALUE);
        this.mask = tableSize - 1;
        boolean hasMissingValue = false;
        int size = 0;
        long previousValue = Long.MIN_VALUE;
        for (long value : values2) {
            if (value == Long.MIN_VALUE) {
                size += hasMissingValue ? 0 : 1;
                hasMissingValue = true;
            } else if (this.add(value)) {
                ++size;
            }
            assert (value >= previousValue) : "values must be provided in sorted order";
            previousValue = value;
        }
        this.hasMissingValue = hasMissingValue;
        this.size = size;
        this.minValue = values2.length == 0 ? Long.MAX_VALUE : values2[0];
        this.maxValue = values2.length == 0 ? Long.MIN_VALUE : values2[values2.length - 1];
    }

    private boolean add(long l) {
        int slot;
        assert (l != Long.MIN_VALUE);
        int i = slot = Long.hashCode(l) & this.mask;
        while (true) {
            if (this.table[i] == Long.MIN_VALUE) {
                this.table[i] = l;
                return true;
            }
            if (this.table[i] == l) {
                return false;
            }
            i = i + 1 & this.mask;
        }
    }

    boolean contains(long l) {
        int slot;
        if (l == Long.MIN_VALUE) {
            return this.hasMissingValue;
        }
        int i = slot = Long.hashCode(l) & this.mask;
        while (this.table[i] != Long.MIN_VALUE) {
            if (this.table[i] == l) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    LongStream stream() {
        LongStream stream = Arrays.stream(this.table).filter(v -> v != Long.MIN_VALUE);
        if (this.hasMissingValue) {
            stream = LongStream.concat(LongStream.of(Long.MIN_VALUE), stream);
        }
        return stream;
    }

    public int hashCode() {
        return Objects.hash(this.size, this.minValue, this.maxValue, this.mask, this.hasMissingValue, Arrays.hashCode(this.table));
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DocValuesLongHashSet) {
            DocValuesLongHashSet that = (DocValuesLongHashSet)obj;
            return this.size == that.size && this.minValue == that.minValue && this.maxValue == that.maxValue && this.mask == that.mask && this.hasMissingValue == that.hasMissingValue && Arrays.equals(this.table, that.table);
        }
        return false;
    }

    public String toString() {
        return this.stream().mapToObj(String::valueOf).collect(Collectors.joining(", ", "[", "]"));
    }

    int size() {
        return this.size;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.table);
    }
}

