/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.document;

import com.dataiku.dss.shadelib.org.apache.lucene.document.Field;
import com.dataiku.dss.shadelib.org.apache.lucene.document.FieldType;
import com.dataiku.dss.shadelib.org.apache.lucene.index.VectorEncoding;
import com.dataiku.dss.shadelib.org.apache.lucene.index.VectorSimilarityFunction;
import com.dataiku.dss.shadelib.org.apache.lucene.search.KnnByteVectorQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import java.util.Objects;

public class KnnByteVectorField
extends Field {
    private static FieldType createType(byte[] v, VectorSimilarityFunction similarityFunction) {
        if (v == null) {
            throw new IllegalArgumentException("vector value must not be null");
        }
        int dimension = v.length;
        if (dimension == 0) {
            throw new IllegalArgumentException("cannot index an empty vector");
        }
        if (similarityFunction == null) {
            throw new IllegalArgumentException("similarity function must not be null");
        }
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, VectorEncoding.BYTE, similarityFunction);
        type.freeze();
        return type;
    }

    public static Query newVectorQuery(String field, byte[] queryVector, int k) {
        return new KnnByteVectorQuery(field, queryVector, k);
    }

    public static FieldType createFieldType(int dimension, VectorSimilarityFunction similarityFunction) {
        FieldType type = new FieldType();
        type.setVectorAttributes(dimension, VectorEncoding.BYTE, similarityFunction);
        type.freeze();
        return type;
    }

    public KnnByteVectorField(String name, byte[] vector, VectorSimilarityFunction similarityFunction) {
        super(name, KnnByteVectorField.createType(vector, similarityFunction));
        this.fieldsData = vector;
    }

    public KnnByteVectorField(String name, byte[] vector) {
        this(name, vector, VectorSimilarityFunction.EUCLIDEAN);
    }

    public KnnByteVectorField(String name, byte[] vector, FieldType fieldType) {
        super(name, fieldType);
        if (fieldType.vectorEncoding() != VectorEncoding.BYTE) {
            throw new IllegalArgumentException("Attempt to create a vector for field " + name + " using byte[] but the field encoding is " + fieldType.vectorEncoding());
        }
        Objects.requireNonNull(vector, "vector value must not be null");
        if (vector.length != fieldType.vectorDimension()) {
            throw new IllegalArgumentException("The number of vector dimensions does not match the field type");
        }
        this.fieldsData = vector;
    }

    public byte[] vectorValue() {
        return (byte[])this.fieldsData;
    }

    public void setVectorValue(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.length != this.type.vectorDimension()) {
            throw new IllegalArgumentException("value length " + value.length + " must match field dimension " + this.type.vectorDimension());
        }
        this.fieldsData = value;
    }
}

