/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.column.schema;

public enum EdgeInterpolationAlgorithm {
    SPHERICAL(0),
    VINCENTY(1),
    THOMAS(2),
    ANDOYER(3),
    KARNEY(4);

    private final int value;

    private EdgeInterpolationAlgorithm(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static EdgeInterpolationAlgorithm findByValue(int value) {
        switch (value) {
            case 0: {
                return SPHERICAL;
            }
            case 1: {
                return VINCENTY;
            }
            case 2: {
                return THOMAS;
            }
            case 3: {
                return ANDOYER;
            }
            case 4: {
                return KARNEY;
            }
        }
        throw new IllegalArgumentException("Unrecognized EdgeInterpolationAlgorithm value: " + value);
    }
}

