/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.hadoop.example;

import com.dataiku.dss.shadelib.org.apache.parquet.conf.HadoopParquetConfiguration;
import com.dataiku.dss.shadelib.org.apache.parquet.conf.ParquetConfiguration;
import com.dataiku.dss.shadelib.org.apache.parquet.example.data.Group;
import com.dataiku.dss.shadelib.org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import com.dataiku.dss.shadelib.org.apache.parquet.hadoop.api.ReadSupport;
import com.dataiku.dss.shadelib.org.apache.parquet.io.api.RecordMaterializer;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.MessageType;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class GroupReadSupport
extends ReadSupport<Group> {
    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        return this.init(new HadoopParquetConfiguration(configuration), keyValueMetaData, fileSchema);
    }

    @Override
    public ReadSupport.ReadContext init(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = GroupReadSupport.getSchemaForRead(fileSchema, partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(ParquetConfiguration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

