/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.parquet.schema;

import com.dataiku.dss.shadelib.org.apache.parquet.Preconditions;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.GroupType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.LogicalTypeAnnotation;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.PrimitiveType;
import com.dataiku.dss.shadelib.org.apache.parquet.schema.Type;

public abstract class ConversionPatterns {
    static final String MAP_REPEATED_NAME = "key_value";
    private static final String ELEMENT_NAME = "element";

    private static GroupType listWrapper(Type.Repetition repetition, String alias, LogicalTypeAnnotation logicalTypeAnnotation, Type nested) {
        if (!nested.isRepetition(Type.Repetition.REPEATED)) {
            throw new IllegalArgumentException("Nested type should be repeated: " + nested);
        }
        return new GroupType(repetition, alias, logicalTypeAnnotation, nested);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, Type keyType, Type valueType) {
        return ConversionPatterns.mapType(repetition, alias, MAP_REPEATED_NAME, keyType, valueType);
    }

    public static GroupType stringKeyMapType(Type.Repetition repetition, String alias, String mapAlias, Type valueType) {
        return ConversionPatterns.mapType(repetition, alias, mapAlias, new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "key", LogicalTypeAnnotation.stringType()), valueType);
    }

    public static GroupType stringKeyMapType(Type.Repetition repetition, String alias, Type valueType) {
        return ConversionPatterns.stringKeyMapType(repetition, alias, MAP_REPEATED_NAME, valueType);
    }

    public static GroupType mapType(Type.Repetition repetition, String alias, String mapAlias, Type keyType, Type valueType) {
        if (valueType == null) {
            return ConversionPatterns.listWrapper(repetition, alias, LogicalTypeAnnotation.mapType(), new GroupType(Type.Repetition.REPEATED, mapAlias, (LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance(), keyType));
        }
        if (!valueType.getName().equals("value")) {
            throw new RuntimeException(valueType.getName() + " should be value");
        }
        return ConversionPatterns.listWrapper(repetition, alias, LogicalTypeAnnotation.mapType(), new GroupType(Type.Repetition.REPEATED, mapAlias, (LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance(), keyType, valueType));
    }

    @Deprecated
    public static GroupType listType(Type.Repetition repetition, String alias, Type nestedType) {
        return ConversionPatterns.listWrapper(repetition, alias, LogicalTypeAnnotation.listType(), nestedType);
    }

    public static GroupType listOfElements(Type.Repetition listRepetition, String name, Type elementType) {
        Preconditions.checkArgument(elementType.getName().equals(ELEMENT_NAME), "List element type must be named 'element'");
        return ConversionPatterns.listWrapper(listRepetition, name, LogicalTypeAnnotation.listType(), new GroupType(Type.Repetition.REPEATED, "list", elementType));
    }
}

