/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.SerializedInvoker;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public class SerializedExecutor
implements Executor {
    private final Executor _executor;
    private final SerializedInvoker _invoker;

    public SerializedExecutor() {
        this(Runnable::run);
    }

    public SerializedExecutor(Executor executor) {
        this._executor = executor;
        this._invoker = new SerializedInvoker(SerializedExecutor.class.getSimpleName(), executor){

            @Override
            protected void onError(Runnable task, Throwable t2) {
                SerializedExecutor.this.onError(task, t2);
            }
        };
    }

    protected void onError(Runnable task, Throwable t2) {
        block3: {
            try {
                if (task instanceof ErrorHandlingTask) {
                    ((ErrorHandlingTask)task).accept(t2);
                }
            }
            catch (Throwable x) {
                if (x == t2) break block3;
                t2.addSuppressed(x);
            }
        }
        LoggerFactory.getLogger(task.getClass()).error("Error", t2);
    }

    @Override
    public void execute(Runnable task) {
        Runnable todo = this._invoker.offer(task);
        if (todo != null) {
            this._executor.execute(todo);
        }
    }

    public void execute(Runnable ... tasks) {
        Runnable todo = this._invoker.offer(tasks);
        if (todo != null) {
            this._executor.execute(todo);
        }
    }

    public static interface ErrorHandlingTask
    extends Runnable,
    Consumer<Throwable> {
    }
}

