/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.VirtualThreads;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedAttribute;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.annotation.ManagedObject;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.component.Dumpable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.AutoLock;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.ThreadPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.TrackingExecutor;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.TryExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="A thread non-pool for virtual threads")
public class VirtualThreadPool
extends ContainerLifeCycle
implements ThreadPool,
Dumpable,
TryExecutor,
VirtualThreads.Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualThreadPool.class);
    private final AutoLock.WithCondition _joinLock = new AutoLock.WithCondition();
    private String _name;
    private int _maxThreads;
    private boolean _tracking;
    private boolean _detailedDump;
    private Thread _keepAlive;
    private Executor _virtualExecutor;
    private boolean _externalExecutor;
    private volatile Semaphore _semaphore;

    public VirtualThreadPool() {
        this(200);
    }

    public VirtualThreadPool(int maxThreads) {
        if (!VirtualThreads.areSupported()) {
            throw new IllegalStateException("Virtual Threads not supported");
        }
        this._maxThreads = maxThreads;
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (StringUtil.isBlank(name) && name != null) {
            throw new IllegalArgumentException("Blank name");
        }
        this._name = name;
    }

    @ManagedAttribute(value="The max number of concurrent virtual threads")
    public int getMaxThreads() {
        return this._maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._maxThreads = maxThreads;
    }

    @ManagedAttribute(value="Whether virtual threads are tracked")
    public boolean isTracking() {
        return this._tracking;
    }

    public void setTracking(boolean tracking) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._tracking = tracking;
    }

    @ManagedAttribute(value="Whether to report additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
        Executor executor = this._virtualExecutor;
        if (executor instanceof TrackingExecutor) {
            TrackingExecutor trackingExecutor = (TrackingExecutor)executor;
            trackingExecutor.setDetailedDump(detailedDump);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._keepAlive = new Thread("jetty-virtual-thread-pool-keepalive"){

            @Override
            public void run() {
                try (AutoLock.WithCondition l = VirtualThreadPool.this._joinLock.lock();){
                    while (VirtualThreadPool.this.isRunning()) {
                        l.await();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this._keepAlive.start();
        if (this._virtualExecutor == null) {
            this._virtualExecutor = Objects.requireNonNull(StringUtil.isBlank(this._name) ? VirtualThreads.getDefaultVirtualThreadsExecutor() : VirtualThreads.getNamedVirtualThreadsExecutor(this._name));
        }
        if (this._tracking && !(this._virtualExecutor instanceof TrackingExecutor)) {
            this._virtualExecutor = new TrackingExecutor(this._virtualExecutor, this.isDetailedDump());
        }
        this.addBean(this._virtualExecutor);
        if (this._maxThreads > 0) {
            this._semaphore = new Semaphore(this._maxThreads);
            this.addBean(this._semaphore);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this._semaphore);
        this._semaphore = null;
        this.removeBean(this._virtualExecutor);
        if (!this._externalExecutor) {
            this._virtualExecutor = null;
        }
        this._keepAlive = null;
        try (AutoLock.WithCondition l = this._joinLock.lock();){
            l.signalAll();
        }
    }

    @Override
    public Executor getVirtualThreadsExecutor() {
        return this._virtualExecutor;
    }

    @Override
    public void setVirtualThreadsExecutor(Executor executor) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._externalExecutor = executor != null;
        this._virtualExecutor = executor;
    }

    @Override
    public void join() throws InterruptedException {
        try (AutoLock.WithCondition l = this._joinLock.lock();){
            while (this.isRunning()) {
                l.await();
            }
        }
        while (this.isStopping()) {
            Thread.onSpinWait();
        }
    }

    @Override
    public int getThreads() {
        int n;
        Executor executor = this._virtualExecutor;
        if (executor instanceof TrackingExecutor) {
            TrackingExecutor tracking = (TrackingExecutor)executor;
            n = tracking.size();
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int getIdleThreads() {
        return 0;
    }

    @Override
    public boolean isLowOnThreads() {
        return false;
    }

    @Override
    public boolean tryExecute(Runnable task) {
        try {
            this.execute(task);
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.warn("tryExecute {} failed", (Object)this._name, (Object)e);
            return false;
        }
    }

    @Override
    public void execute(Runnable task) {
        Runnable job = task;
        Semaphore semaphore = this._semaphore;
        if (semaphore != null) {
            job = () -> {
                try {
                    semaphore.acquire();
                    task.run();
                }
                catch (InterruptedException x) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("interrupted while waiting for permit {}", (Object)task, (Object)x);
                    }
                }
                finally {
                    semaphore.release();
                }
            };
        }
        this._virtualExecutor.execute(job);
    }
}

