/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.api.ns;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.DeleteNamespaceResult;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetContentBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetEntriesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.builder.BaseDeleteNamespaceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.error.ContentKeyErrorDetails;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieContentNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotEmptyException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.Branch;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitMeta;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Content;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Operation;
import com.dataiku.dss.shadelib.org.projectnessie.model.Reference;

public final class ClientSideDeleteNamespace
extends BaseDeleteNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideDeleteNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void delete() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException, NessieNamespaceNotEmptyException {
        this.deleteWithResponse();
    }

    @Override
    public DeleteNamespaceResult deleteWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException, NessieNamespaceNotEmptyException {
        Content existing;
        Reference ref;
        ContentKey key = this.namespace.toContentKey();
        try {
            ContentResponse contentResponse = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).getSingle(key);
            ref = contentResponse.getEffectiveReference();
            if (!(ref instanceof Branch)) {
                throw new NessieReferenceNotFoundException("Must only commit against a branch, but got " + String.valueOf(ref));
            }
            existing = contentResponse.getContent();
        }
        catch (NessieContentNotFoundException e) {
            existing = null;
            ref = null;
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        if (!(existing instanceof Namespace)) {
            throw new NessieNamespaceNotFoundException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Namespace '%s' does not exist", key.toCanonicalString()));
        }
        try {
            if (((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().reference(ref)).filter(String.format("entry.encodedKey.startsWith('%s.')", this.namespace.toPathString()))).stream().findAny().isPresent()) {
                throw new NessieNamespaceNotEmptyException(ContentKeyErrorDetails.contentKeyErrorDetails(key), String.format("Namespace '%s' is not empty", key.toCanonicalString()));
            }
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        try {
            CommitMeta meta = this.commitMeta;
            if (meta == null) {
                meta = CommitMeta.fromMessage("delete namespace " + String.valueOf(key));
            } else if (meta.getMessage().isEmpty()) {
                meta = CommitMeta.builder().from(meta).message("delete namespace " + String.valueOf(key)).build();
            }
            CommitResponse commit = ((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branch((Branch)ref)).commitMeta(meta).operation(Operation.Delete.of(key)).commitWithResponse();
            return DeleteNamespaceResult.of(this.namespace, commit.getTargetBranch());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e);
        }
    }
}

