/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.api.ns;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetEntriesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.builder.BaseGetMultipleNamespacesBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.EntriesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.GetNamespacesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableGetNamespacesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import java.util.Objects;
import java.util.Optional;

public final class ClientSideGetMultipleNamespaces
extends BaseGetMultipleNamespacesBuilder {
    private final NessieApiV2 api;
    private boolean onlyDirectChildren;

    public ClientSideGetMultipleNamespaces(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public GetMultipleNamespacesBuilder onlyDirectChildren(boolean onlyDirectChildren) {
        this.onlyDirectChildren = onlyDirectChildren;
        return this;
    }

    @Override
    public GetNamespacesResponse get() throws NessieReferenceNotFoundException {
        ImmutableGetNamespacesResponse.Builder builder = GetNamespacesResponse.builder();
        try {
            EntriesResponse response;
            GetEntriesBuilder getEntries = ((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().maxRecords(100)).refName(this.refName)).hashOnRef(this.hashOnRef)).withContent(true);
            Object filter = "entry.contentType == 'NAMESPACE'";
            if (this.namespace != null && !this.namespace.isEmpty()) {
                String nsName = this.namespace.toPathString();
                filter = (String)filter + (this.onlyDirectChildren ? String.format(" && size(entry.keyElements) == %d && entry.encodedKey.startsWith('%s.')", this.namespace.getElementCount() + 1, nsName) : String.format("&& (entry.encodedKey == '%s' || entry.encodedKey.startsWith('%s.'))", nsName, nsName));
            } else if (this.onlyDirectChildren) {
                filter = (String)filter + " && size(entry.keyElements) == 1";
            }
            getEntries.filter((String)filter);
            do {
                response = getEntries.get();
                builder.effectiveReference(response.getEffectiveReference());
                response.getEntries().stream().map(EntriesResponse.Entry::getContent).filter(Objects::nonNull).map(v -> v.unwrap(Namespace.class)).filter(Optional::isPresent).map(Optional::get).forEach(builder::addNamespaces);
                getEntries = (GetEntriesBuilder)getEntries.pageToken(response.getToken());
            } while (response.isHasMore());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        return builder.build();
    }
}

