/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.api.ns;

import com.dataiku.dss.shadelib.org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.GetNamespaceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.NessieApiV2;
import com.dataiku.dss.shadelib.org.projectnessie.client.api.UpdateNamespaceResult;
import com.dataiku.dss.shadelib.org.projectnessie.client.builder.BaseUpdateNamespaceBuilder;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieConflictException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitMeta;
import com.dataiku.dss.shadelib.org.projectnessie.model.CommitResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.ContentKey;
import com.dataiku.dss.shadelib.org.projectnessie.model.ImmutableNamespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import com.dataiku.dss.shadelib.org.projectnessie.model.Operation;
import java.util.HashMap;

public final class ClientSideUpdateNamespace
extends BaseUpdateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideUpdateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void update() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.updateWithResponse();
    }

    @Override
    public UpdateNamespaceResult updateWithResponse() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = this.namespace.toContentKey();
        Namespace oldNamespace = ((GetNamespaceBuilder)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api.getNamespace().refName(this.refName)).hashOnRef(this.hashOnRef)).namespace(this.namespace)).get();
        HashMap<String, String> newProperties = new HashMap<String, String>(oldNamespace.getProperties());
        this.propertyRemovals.forEach(newProperties::remove);
        newProperties.putAll(this.propertyUpdates);
        ImmutableNamespace.Builder builder = Namespace.builder().from(oldNamespace).properties(newProperties);
        try {
            CommitMeta meta;
            String expectedHash = this.hashOnRef;
            if (expectedHash == null) {
                expectedHash = this.api.getReference().refName(this.refName).get().getHash();
            }
            if ((meta = this.commitMeta) == null) {
                meta = CommitMeta.fromMessage("update namespace " + String.valueOf(key));
            } else if (meta.getMessage().isEmpty()) {
                meta = CommitMeta.builder().from(meta).message("update namespace " + String.valueOf(key)).build();
            }
            ImmutableNamespace updatedNamespace = builder.build();
            CommitResponse commit = ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(this.refName)).hash(expectedHash)).commitMeta(meta).operation(Operation.Put.of(key, updatedNamespace)).commitWithResponse();
            return UpdateNamespaceResult.of(updatedNamespace, oldNamespace, commit.getTargetBranch());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

