/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2;

import com.dataiku.dss.shadelib.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelib.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.CheckReturnValue;
import com.dataiku.dss.shadelib.javax.annotation.ParametersAreNonnullByDefault;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.Immutable;
import com.dataiku.dss.shadelib.javax.annotation.concurrent.NotThreadSafe;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.GrantType;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.ImpersonationConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.OAuth2AuthenticatorConfig;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.Secret;
import com.dataiku.dss.shadelib.org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OAuth2AuthenticatorConfig", generator="Immutables")
@Immutable
public final class ImmutableOAuth2AuthenticatorConfig
implements OAuth2AuthenticatorConfig {
    private final URI issuerUrl;
    private final URI tokenEndpoint;
    private final URI authEndpoint;
    private final URI deviceAuthEndpoint;
    private final GrantType grantType;
    private final String clientId;
    private final Secret clientSecret;
    private final Supplier<String> clientSecretSupplier;
    private final String username;
    private final Secret password;
    private final Supplier<String> passwordSupplier;
    private final transient Optional<String> scope;
    private final List<String> scopes;
    private final Map<String, String> extraRequestParameters;
    private final boolean tokenExchangeEnabled;
    private final TokenExchangeConfig tokenExchangeConfig;
    private final ImpersonationConfig impersonationConfig;
    private final Duration defaultAccessTokenLifespan;
    private final Duration defaultRefreshTokenLifespan;
    private final Duration refreshSafetyWindow;
    private final Duration preemptiveTokenRefreshIdleTimeout;
    private final Duration backgroundThreadIdleTimeout;
    private final Duration authorizationCodeFlowTimeout;
    private final Integer authorizationCodeFlowWebServerPort;
    private final Duration deviceCodeFlowTimeout;
    private final Duration deviceCodeFlowPollInterval;
    private final SSLContext sslContext;
    private final ObjectMapper objectMapper;
    private final ScheduledExecutorService executor;
    private transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOAuth2AuthenticatorConfig(Builder builder) {
        this.issuerUrl = builder.issuerUrl;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.authEndpoint = builder.authEndpoint;
        this.deviceAuthEndpoint = builder.deviceAuthEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientSecretSupplier = builder.clientSecretSupplier;
        this.username = builder.username;
        this.password = builder.password;
        this.passwordSupplier = builder.passwordSupplier;
        this.scopes = ImmutableOAuth2AuthenticatorConfig.createUnmodifiableList(true, builder.scopes);
        this.extraRequestParameters = ImmutableOAuth2AuthenticatorConfig.createUnmodifiableMap(false, false, builder.extraRequestParameters);
        this.authorizationCodeFlowWebServerPort = builder.authorizationCodeFlowWebServerPort;
        this.sslContext = builder.sslContext;
        this.executor = builder.executor;
        if (builder.grantType != null) {
            this.initShim.grantType(builder.grantType);
        }
        if (builder.tokenExchangeEnabledIsSet()) {
            this.initShim.tokenExchangeEnabled(builder.tokenExchangeEnabled);
        }
        if (builder.tokenExchangeConfig != null) {
            this.initShim.tokenExchangeConfig(builder.tokenExchangeConfig);
        }
        if (builder.impersonationConfig != null) {
            this.initShim.impersonationConfig(builder.impersonationConfig);
        }
        if (builder.defaultAccessTokenLifespan != null) {
            this.initShim.defaultAccessTokenLifespan(builder.defaultAccessTokenLifespan);
        }
        if (builder.defaultRefreshTokenLifespan != null) {
            this.initShim.defaultRefreshTokenLifespan(builder.defaultRefreshTokenLifespan);
        }
        if (builder.refreshSafetyWindow != null) {
            this.initShim.refreshSafetyWindow(builder.refreshSafetyWindow);
        }
        if (builder.preemptiveTokenRefreshIdleTimeout != null) {
            this.initShim.preemptiveTokenRefreshIdleTimeout(builder.preemptiveTokenRefreshIdleTimeout);
        }
        if (builder.backgroundThreadIdleTimeout != null) {
            this.initShim.backgroundThreadIdleTimeout(builder.backgroundThreadIdleTimeout);
        }
        if (builder.authorizationCodeFlowTimeout != null) {
            this.initShim.authorizationCodeFlowTimeout(builder.authorizationCodeFlowTimeout);
        }
        if (builder.deviceCodeFlowTimeout != null) {
            this.initShim.deviceCodeFlowTimeout(builder.deviceCodeFlowTimeout);
        }
        if (builder.deviceCodeFlowPollInterval != null) {
            this.initShim.deviceCodeFlowPollInterval(builder.deviceCodeFlowPollInterval);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        this.grantType = this.initShim.getGrantType();
        this.scope = this.initShim.getScope();
        this.tokenExchangeEnabled = this.initShim.getTokenExchangeEnabled();
        this.tokenExchangeConfig = this.initShim.getTokenExchangeConfig();
        this.impersonationConfig = this.initShim.getImpersonationConfig();
        this.defaultAccessTokenLifespan = this.initShim.getDefaultAccessTokenLifespan();
        this.defaultRefreshTokenLifespan = this.initShim.getDefaultRefreshTokenLifespan();
        this.refreshSafetyWindow = this.initShim.getRefreshSafetyWindow();
        this.preemptiveTokenRefreshIdleTimeout = this.initShim.getPreemptiveTokenRefreshIdleTimeout();
        this.backgroundThreadIdleTimeout = this.initShim.getBackgroundThreadIdleTimeout();
        this.authorizationCodeFlowTimeout = this.initShim.getAuthorizationCodeFlowTimeout();
        this.deviceCodeFlowTimeout = this.initShim.getDeviceCodeFlowTimeout();
        this.deviceCodeFlowPollInterval = this.initShim.getDeviceCodeFlowPollInterval();
        this.objectMapper = this.initShim.getObjectMapper();
        this.initShim = null;
    }

    private ImmutableOAuth2AuthenticatorConfig(URI issuerUrl, URI tokenEndpoint, URI authEndpoint, URI deviceAuthEndpoint, GrantType grantType, String clientId, Secret clientSecret, Supplier<String> clientSecretSupplier, String username, Secret password, Supplier<String> passwordSupplier, List<String> scopes, Map<String, String> extraRequestParameters, boolean tokenExchangeEnabled, TokenExchangeConfig tokenExchangeConfig, ImpersonationConfig impersonationConfig, Duration defaultAccessTokenLifespan, Duration defaultRefreshTokenLifespan, Duration refreshSafetyWindow, Duration preemptiveTokenRefreshIdleTimeout, Duration backgroundThreadIdleTimeout, Duration authorizationCodeFlowTimeout, Integer authorizationCodeFlowWebServerPort, Duration deviceCodeFlowTimeout, Duration deviceCodeFlowPollInterval, SSLContext sslContext, ObjectMapper objectMapper, ScheduledExecutorService executor) {
        this.issuerUrl = issuerUrl;
        this.tokenEndpoint = tokenEndpoint;
        this.authEndpoint = authEndpoint;
        this.deviceAuthEndpoint = deviceAuthEndpoint;
        this.initShim.grantType(grantType);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.clientSecretSupplier = clientSecretSupplier;
        this.username = username;
        this.password = password;
        this.passwordSupplier = passwordSupplier;
        this.scopes = scopes;
        this.extraRequestParameters = extraRequestParameters;
        this.initShim.tokenExchangeEnabled(tokenExchangeEnabled);
        this.initShim.tokenExchangeConfig(tokenExchangeConfig);
        this.initShim.impersonationConfig(impersonationConfig);
        this.initShim.defaultAccessTokenLifespan(defaultAccessTokenLifespan);
        this.initShim.defaultRefreshTokenLifespan(defaultRefreshTokenLifespan);
        this.initShim.refreshSafetyWindow(refreshSafetyWindow);
        this.initShim.preemptiveTokenRefreshIdleTimeout(preemptiveTokenRefreshIdleTimeout);
        this.initShim.backgroundThreadIdleTimeout(backgroundThreadIdleTimeout);
        this.initShim.authorizationCodeFlowTimeout(authorizationCodeFlowTimeout);
        this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort;
        this.initShim.deviceCodeFlowTimeout(deviceCodeFlowTimeout);
        this.initShim.deviceCodeFlowPollInterval(deviceCodeFlowPollInterval);
        this.sslContext = sslContext;
        this.initShim.objectMapper(objectMapper);
        this.executor = executor;
        this.grantType = this.initShim.getGrantType();
        this.scope = this.initShim.getScope();
        this.tokenExchangeEnabled = this.initShim.getTokenExchangeEnabled();
        this.tokenExchangeConfig = this.initShim.getTokenExchangeConfig();
        this.impersonationConfig = this.initShim.getImpersonationConfig();
        this.defaultAccessTokenLifespan = this.initShim.getDefaultAccessTokenLifespan();
        this.defaultRefreshTokenLifespan = this.initShim.getDefaultRefreshTokenLifespan();
        this.refreshSafetyWindow = this.initShim.getRefreshSafetyWindow();
        this.preemptiveTokenRefreshIdleTimeout = this.initShim.getPreemptiveTokenRefreshIdleTimeout();
        this.backgroundThreadIdleTimeout = this.initShim.getBackgroundThreadIdleTimeout();
        this.authorizationCodeFlowTimeout = this.initShim.getAuthorizationCodeFlowTimeout();
        this.deviceCodeFlowTimeout = this.initShim.getDeviceCodeFlowTimeout();
        this.deviceCodeFlowPollInterval = this.initShim.getDeviceCodeFlowPollInterval();
        this.objectMapper = this.initShim.getObjectMapper();
        this.initShim = null;
    }

    private GrantType getGrantTypeInitialize() {
        return OAuth2AuthenticatorConfig.super.getGrantType();
    }

    private Optional<String> getScopeInitialize() {
        return OAuth2AuthenticatorConfig.super.getScope();
    }

    private boolean getTokenExchangeEnabledInitialize() {
        return OAuth2AuthenticatorConfig.super.getTokenExchangeEnabled();
    }

    private TokenExchangeConfig getTokenExchangeConfigInitialize() {
        return OAuth2AuthenticatorConfig.super.getTokenExchangeConfig();
    }

    private ImpersonationConfig getImpersonationConfigInitialize() {
        return OAuth2AuthenticatorConfig.super.getImpersonationConfig();
    }

    private Duration getDefaultAccessTokenLifespanInitialize() {
        return OAuth2AuthenticatorConfig.super.getDefaultAccessTokenLifespan();
    }

    private Duration getDefaultRefreshTokenLifespanInitialize() {
        return OAuth2AuthenticatorConfig.super.getDefaultRefreshTokenLifespan();
    }

    private Duration getRefreshSafetyWindowInitialize() {
        return OAuth2AuthenticatorConfig.super.getRefreshSafetyWindow();
    }

    private Duration getPreemptiveTokenRefreshIdleTimeoutInitialize() {
        return OAuth2AuthenticatorConfig.super.getPreemptiveTokenRefreshIdleTimeout();
    }

    private Duration getBackgroundThreadIdleTimeoutInitialize() {
        return OAuth2AuthenticatorConfig.super.getBackgroundThreadIdleTimeout();
    }

    private Duration getAuthorizationCodeFlowTimeoutInitialize() {
        return OAuth2AuthenticatorConfig.super.getAuthorizationCodeFlowTimeout();
    }

    private Duration getDeviceCodeFlowTimeoutInitialize() {
        return OAuth2AuthenticatorConfig.super.getDeviceCodeFlowTimeout();
    }

    private Duration getDeviceCodeFlowPollIntervalInitialize() {
        return OAuth2AuthenticatorConfig.super.getDeviceCodeFlowPollInterval();
    }

    private ObjectMapper getObjectMapperInitialize() {
        return OAuth2AuthenticatorConfig.super.getObjectMapper();
    }

    @Override
    public Optional<URI> getIssuerUrl() {
        return Optional.ofNullable(this.issuerUrl);
    }

    @Override
    public Optional<URI> getTokenEndpoint() {
        return Optional.ofNullable(this.tokenEndpoint);
    }

    @Override
    public Optional<URI> getAuthEndpoint() {
        return Optional.ofNullable(this.authEndpoint);
    }

    @Override
    public Optional<URI> getDeviceAuthEndpoint() {
        return Optional.ofNullable(this.deviceAuthEndpoint);
    }

    @Override
    public GrantType getGrantType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGrantType() : this.grantType;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public Optional<Secret> getClientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    @Override
    public Optional<Supplier<String>> getClientSecretSupplier() {
        return Optional.ofNullable(this.clientSecretSupplier);
    }

    @Override
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    public Optional<Secret> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Override
    public Optional<Supplier<String>> getPasswordSupplier() {
        return Optional.ofNullable(this.passwordSupplier);
    }

    @Override
    @Deprecated
    public Optional<String> getScope() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getScope() : this.scope;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public Map<String, String> getExtraRequestParameters() {
        return this.extraRequestParameters;
    }

    @Override
    @Deprecated
    public boolean getTokenExchangeEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTokenExchangeEnabled() : this.tokenExchangeEnabled;
    }

    @Override
    public TokenExchangeConfig getTokenExchangeConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTokenExchangeConfig() : this.tokenExchangeConfig;
    }

    @Override
    public ImpersonationConfig getImpersonationConfig() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getImpersonationConfig() : this.impersonationConfig;
    }

    @Override
    public Duration getDefaultAccessTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultAccessTokenLifespan() : this.defaultAccessTokenLifespan;
    }

    @Override
    public Duration getDefaultRefreshTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultRefreshTokenLifespan() : this.defaultRefreshTokenLifespan;
    }

    @Override
    public Duration getRefreshSafetyWindow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRefreshSafetyWindow() : this.refreshSafetyWindow;
    }

    @Override
    public Duration getPreemptiveTokenRefreshIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPreemptiveTokenRefreshIdleTimeout() : this.preemptiveTokenRefreshIdleTimeout;
    }

    @Override
    public Duration getBackgroundThreadIdleTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBackgroundThreadIdleTimeout() : this.backgroundThreadIdleTimeout;
    }

    @Override
    public Duration getAuthorizationCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getAuthorizationCodeFlowTimeout() : this.authorizationCodeFlowTimeout;
    }

    @Override
    public OptionalInt getAuthorizationCodeFlowWebServerPort() {
        return this.authorizationCodeFlowWebServerPort != null ? OptionalInt.of(this.authorizationCodeFlowWebServerPort) : OptionalInt.empty();
    }

    @Override
    public Duration getDeviceCodeFlowTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDeviceCodeFlowTimeout() : this.deviceCodeFlowTimeout;
    }

    @Override
    public Duration getDeviceCodeFlowPollInterval() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDeviceCodeFlowPollInterval() : this.deviceCodeFlowPollInterval;
    }

    @Override
    public Optional<SSLContext> getSslContext() {
        return Optional.ofNullable(this.sslContext);
    }

    @Override
    public ObjectMapper getObjectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMapper() : this.objectMapper;
    }

    @Override
    public Optional<ScheduledExecutorService> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withIssuerUrl(URI value) {
        URI newValue = Objects.requireNonNull(value, "issuerUrl");
        if (this.issuerUrl == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(newValue, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withIssuerUrl(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.issuerUrl == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(value, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withTokenEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "tokenEndpoint");
        if (this.tokenEndpoint == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, newValue, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withTokenEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.tokenEndpoint == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, value, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withAuthEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "authEndpoint");
        if (this.authEndpoint == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, newValue, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withAuthEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.authEndpoint == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, value, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDeviceAuthEndpoint(URI value) {
        URI newValue = Objects.requireNonNull(value, "deviceAuthEndpoint");
        if (this.deviceAuthEndpoint == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, newValue, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDeviceAuthEndpoint(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.deviceAuthEndpoint == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, value, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withGrantType(GrantType value) {
        GrantType newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, newValue, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, newValue, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withClientSecret(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, newValue, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withClientSecret(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.clientSecret == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, value, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withClientSecretSupplier(Supplier<String> value) {
        Supplier<String> newValue = Objects.requireNonNull(value, "clientSecretSupplier");
        if (this.clientSecretSupplier == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, newValue, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withClientSecretSupplier(Optional<? extends Supplier<String>> optional) {
        Supplier value = optional.orElse(null);
        if (this.clientSecretSupplier == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, value, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, newValue, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, value, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withPassword(Secret value) {
        Secret newValue = Objects.requireNonNull(value, "password");
        if (this.password == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, newValue, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withPassword(Optional<? extends Secret> optional) {
        Secret value = optional.orElse(null);
        if (this.password == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, value, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withPasswordSupplier(Supplier<String> value) {
        Supplier<String> newValue = Objects.requireNonNull(value, "passwordSupplier");
        if (this.passwordSupplier == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, newValue, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withPasswordSupplier(Optional<? extends Supplier<String>> optional) {
        Supplier value = optional.orElse(null);
        if (this.passwordSupplier == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, value, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withScopes(String ... elements) {
        List<String> newValue = ImmutableOAuth2AuthenticatorConfig.createUnmodifiableList(false, ImmutableOAuth2AuthenticatorConfig.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, newValue, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withScopes(Iterable<String> elements) {
        if (this.scopes == elements) {
            return this;
        }
        List<String> newValue = ImmutableOAuth2AuthenticatorConfig.createUnmodifiableList(false, ImmutableOAuth2AuthenticatorConfig.createSafeList(elements, true, false));
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, newValue, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withExtraRequestParameters(Map<String, ? extends String> entries) {
        if (this.extraRequestParameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableOAuth2AuthenticatorConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, newValue, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    @Deprecated
    public final ImmutableOAuth2AuthenticatorConfig withTokenExchangeEnabled(boolean value) {
        if (this.tokenExchangeEnabled == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, value, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withTokenExchangeConfig(TokenExchangeConfig value) {
        if (this.tokenExchangeConfig == value) {
            return this;
        }
        TokenExchangeConfig newValue = Objects.requireNonNull(value, "tokenExchangeConfig");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, newValue, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withImpersonationConfig(ImpersonationConfig value) {
        if (this.impersonationConfig == value) {
            return this;
        }
        ImpersonationConfig newValue = Objects.requireNonNull(value, "impersonationConfig");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, newValue, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDefaultAccessTokenLifespan(Duration value) {
        if (this.defaultAccessTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultAccessTokenLifespan");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, newValue, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDefaultRefreshTokenLifespan(Duration value) {
        if (this.defaultRefreshTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultRefreshTokenLifespan");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, newValue, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withRefreshSafetyWindow(Duration value) {
        if (this.refreshSafetyWindow == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "refreshSafetyWindow");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, newValue, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withPreemptiveTokenRefreshIdleTimeout(Duration value) {
        if (this.preemptiveTokenRefreshIdleTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "preemptiveTokenRefreshIdleTimeout");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, newValue, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withBackgroundThreadIdleTimeout(Duration value) {
        if (this.backgroundThreadIdleTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "backgroundThreadIdleTimeout");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, newValue, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withAuthorizationCodeFlowTimeout(Duration value) {
        if (this.authorizationCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "authorizationCodeFlowTimeout");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, newValue, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withAuthorizationCodeFlowWebServerPort(int value) {
        Integer newValue = value;
        if (Objects.equals(this.authorizationCodeFlowWebServerPort, newValue)) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, newValue, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withAuthorizationCodeFlowWebServerPort(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.authorizationCodeFlowWebServerPort, value)) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, value, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDeviceCodeFlowTimeout(Duration value) {
        if (this.deviceCodeFlowTimeout == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "deviceCodeFlowTimeout");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, newValue, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withDeviceCodeFlowPollInterval(Duration value) {
        if (this.deviceCodeFlowPollInterval == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "deviceCodeFlowPollInterval");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, newValue, this.sslContext, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withSslContext(SSLContext value) {
        SSLContext newValue = Objects.requireNonNull(value, "sslContext");
        if (this.sslContext == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, newValue, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withSslContext(Optional<? extends SSLContext> optional) {
        SSLContext value = optional.orElse(null);
        if (this.sslContext == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, value, this.objectMapper, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, newValue, this.executor);
    }

    public final ImmutableOAuth2AuthenticatorConfig withExecutor(ScheduledExecutorService value) {
        ScheduledExecutorService newValue = Objects.requireNonNull(value, "executor");
        if (this.executor == newValue) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, newValue);
    }

    public final ImmutableOAuth2AuthenticatorConfig withExecutor(Optional<? extends ScheduledExecutorService> optional) {
        ScheduledExecutorService value = optional.orElse(null);
        if (this.executor == value) {
            return this;
        }
        return new ImmutableOAuth2AuthenticatorConfig(this.issuerUrl, this.tokenEndpoint, this.authEndpoint, this.deviceAuthEndpoint, this.grantType, this.clientId, this.clientSecret, this.clientSecretSupplier, this.username, this.password, this.passwordSupplier, this.scopes, this.extraRequestParameters, this.tokenExchangeEnabled, this.tokenExchangeConfig, this.impersonationConfig, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.preemptiveTokenRefreshIdleTimeout, this.backgroundThreadIdleTimeout, this.authorizationCodeFlowTimeout, this.authorizationCodeFlowWebServerPort, this.deviceCodeFlowTimeout, this.deviceCodeFlowPollInterval, this.sslContext, this.objectMapper, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2AuthenticatorConfig && this.equalsByValue((ImmutableOAuth2AuthenticatorConfig)another);
    }

    private boolean equalsByValue(ImmutableOAuth2AuthenticatorConfig another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.issuerUrl, another.issuerUrl) && Objects.equals(this.tokenEndpoint, another.tokenEndpoint) && Objects.equals(this.authEndpoint, another.authEndpoint) && Objects.equals(this.deviceAuthEndpoint, another.deviceAuthEndpoint) && this.grantType.equals((Object)another.grantType) && this.clientId.equals(another.clientId) && Objects.equals(this.clientSecret, another.clientSecret) && Objects.equals(this.clientSecretSupplier, another.clientSecretSupplier) && Objects.equals(this.username, another.username) && Objects.equals(this.password, another.password) && Objects.equals(this.passwordSupplier, another.passwordSupplier) && this.scope.equals(another.scope) && this.scopes.equals(another.scopes) && this.extraRequestParameters.equals(another.extraRequestParameters) && this.tokenExchangeEnabled == another.tokenExchangeEnabled && this.tokenExchangeConfig.equals(another.tokenExchangeConfig) && this.impersonationConfig.equals(another.impersonationConfig) && this.defaultAccessTokenLifespan.equals(another.defaultAccessTokenLifespan) && this.defaultRefreshTokenLifespan.equals(another.defaultRefreshTokenLifespan) && this.refreshSafetyWindow.equals(another.refreshSafetyWindow) && this.preemptiveTokenRefreshIdleTimeout.equals(another.preemptiveTokenRefreshIdleTimeout) && this.backgroundThreadIdleTimeout.equals(another.backgroundThreadIdleTimeout) && this.authorizationCodeFlowTimeout.equals(another.authorizationCodeFlowTimeout) && Objects.equals(this.authorizationCodeFlowWebServerPort, another.authorizationCodeFlowWebServerPort) && this.deviceCodeFlowTimeout.equals(another.deviceCodeFlowTimeout) && this.deviceCodeFlowPollInterval.equals(another.deviceCodeFlowPollInterval) && Objects.equals(this.sslContext, another.sslContext) && this.objectMapper.equals(another.objectMapper) && Objects.equals(this.executor, another.executor);
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.issuerUrl);
        h2 += (h2 << 5) + Objects.hashCode(this.tokenEndpoint);
        h2 += (h2 << 5) + Objects.hashCode(this.authEndpoint);
        h2 += (h2 << 5) + Objects.hashCode(this.deviceAuthEndpoint);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.clientId.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.clientSecret);
        h2 += (h2 << 5) + Objects.hashCode(this.clientSecretSupplier);
        h2 += (h2 << 5) + Objects.hashCode(this.username);
        h2 += (h2 << 5) + Objects.hashCode(this.password);
        h2 += (h2 << 5) + Objects.hashCode(this.passwordSupplier);
        h2 += (h2 << 5) + this.scope.hashCode();
        h2 += (h2 << 5) + this.scopes.hashCode();
        h2 += (h2 << 5) + this.extraRequestParameters.hashCode();
        h2 += (h2 << 5) + Boolean.hashCode(this.tokenExchangeEnabled);
        h2 += (h2 << 5) + this.tokenExchangeConfig.hashCode();
        h2 += (h2 << 5) + this.impersonationConfig.hashCode();
        h2 += (h2 << 5) + this.defaultAccessTokenLifespan.hashCode();
        h2 += (h2 << 5) + this.defaultRefreshTokenLifespan.hashCode();
        h2 += (h2 << 5) + this.refreshSafetyWindow.hashCode();
        h2 += (h2 << 5) + this.preemptiveTokenRefreshIdleTimeout.hashCode();
        h2 += (h2 << 5) + this.backgroundThreadIdleTimeout.hashCode();
        h2 += (h2 << 5) + this.authorizationCodeFlowTimeout.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.authorizationCodeFlowWebServerPort);
        h2 += (h2 << 5) + this.deviceCodeFlowTimeout.hashCode();
        h2 += (h2 << 5) + this.deviceCodeFlowPollInterval.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.sslContext);
        h2 += (h2 << 5) + this.objectMapper.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.executor);
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OAuth2AuthenticatorConfig{");
        if (this.issuerUrl != null) {
            builder.append("issuerUrl=").append(this.issuerUrl);
        }
        if (this.tokenEndpoint != null) {
            if (builder.length() > 26) {
                builder.append(", ");
            }
            builder.append("tokenEndpoint=").append(this.tokenEndpoint);
        }
        if (this.authEndpoint != null) {
            if (builder.length() > 26) {
                builder.append(", ");
            }
            builder.append("authEndpoint=").append(this.authEndpoint);
        }
        if (this.deviceAuthEndpoint != null) {
            if (builder.length() > 26) {
                builder.append(", ");
            }
            builder.append("deviceAuthEndpoint=").append(this.deviceAuthEndpoint);
        }
        if (builder.length() > 26) {
            builder.append(", ");
        }
        builder.append("grantType=").append((Object)this.grantType);
        builder.append(", ");
        builder.append("clientId=").append(this.clientId);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        builder.append(", ");
        builder.append("scope=").append(this.scope);
        builder.append(", ");
        builder.append("scopes=").append(this.scopes);
        builder.append(", ");
        builder.append("extraRequestParameters=").append(this.extraRequestParameters);
        builder.append(", ");
        builder.append("tokenExchangeEnabled=").append(this.tokenExchangeEnabled);
        builder.append(", ");
        builder.append("tokenExchangeConfig=").append(this.tokenExchangeConfig);
        builder.append(", ");
        builder.append("impersonationConfig=").append(this.impersonationConfig);
        builder.append(", ");
        builder.append("defaultAccessTokenLifespan=").append(this.defaultAccessTokenLifespan);
        builder.append(", ");
        builder.append("defaultRefreshTokenLifespan=").append(this.defaultRefreshTokenLifespan);
        builder.append(", ");
        builder.append("refreshSafetyWindow=").append(this.refreshSafetyWindow);
        builder.append(", ");
        builder.append("preemptiveTokenRefreshIdleTimeout=").append(this.preemptiveTokenRefreshIdleTimeout);
        builder.append(", ");
        builder.append("backgroundThreadIdleTimeout=").append(this.backgroundThreadIdleTimeout);
        builder.append(", ");
        builder.append("authorizationCodeFlowTimeout=").append(this.authorizationCodeFlowTimeout);
        if (this.authorizationCodeFlowWebServerPort != null) {
            builder.append(", ");
            builder.append("authorizationCodeFlowWebServerPort=").append(this.authorizationCodeFlowWebServerPort);
        }
        builder.append(", ");
        builder.append("deviceCodeFlowTimeout=").append(this.deviceCodeFlowTimeout);
        builder.append(", ");
        builder.append("deviceCodeFlowPollInterval=").append(this.deviceCodeFlowPollInterval);
        if (this.sslContext != null) {
            builder.append(", ");
            builder.append("sslContext=").append(this.sslContext);
        }
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        if (this.executor != null) {
            builder.append(", ");
            builder.append("executor=").append(this.executor);
        }
        return builder.append("}").toString();
    }

    public static ImmutableOAuth2AuthenticatorConfig copyOf(OAuth2AuthenticatorConfig instance) {
        if (instance instanceof ImmutableOAuth2AuthenticatorConfig) {
            return (ImmutableOAuth2AuthenticatorConfig)instance;
        }
        return ImmutableOAuth2AuthenticatorConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="OAuth2AuthenticatorConfig", generator="Immutables")
    private final class InitShim {
        private byte grantTypeBuildStage = 0;
        private GrantType grantType;
        private byte scopeBuildStage = 0;
        private Optional<String> scope;
        private byte tokenExchangeEnabledBuildStage = 0;
        private boolean tokenExchangeEnabled;
        private byte tokenExchangeConfigBuildStage = 0;
        private TokenExchangeConfig tokenExchangeConfig;
        private byte impersonationConfigBuildStage = 0;
        private ImpersonationConfig impersonationConfig;
        private byte defaultAccessTokenLifespanBuildStage = 0;
        private Duration defaultAccessTokenLifespan;
        private byte defaultRefreshTokenLifespanBuildStage = 0;
        private Duration defaultRefreshTokenLifespan;
        private byte refreshSafetyWindowBuildStage = 0;
        private Duration refreshSafetyWindow;
        private byte preemptiveTokenRefreshIdleTimeoutBuildStage = 0;
        private Duration preemptiveTokenRefreshIdleTimeout;
        private byte backgroundThreadIdleTimeoutBuildStage = 0;
        private Duration backgroundThreadIdleTimeout;
        private byte authorizationCodeFlowTimeoutBuildStage = 0;
        private Duration authorizationCodeFlowTimeout;
        private byte deviceCodeFlowTimeoutBuildStage = 0;
        private Duration deviceCodeFlowTimeout;
        private byte deviceCodeFlowPollIntervalBuildStage = 0;
        private Duration deviceCodeFlowPollInterval;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;

        private InitShim() {
        }

        GrantType getGrantType() {
            if (this.grantTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.grantTypeBuildStage == 0) {
                this.grantTypeBuildStage = (byte)-1;
                GrantType computedValue = ImmutableOAuth2AuthenticatorConfig.this.getGrantTypeInitialize();
                this.grantType = Objects.requireNonNull(computedValue, "grantType");
                this.grantTypeBuildStage = 1;
            }
            return this.grantType;
        }

        void grantType(GrantType grantType) {
            this.grantType = grantType;
            this.grantTypeBuildStage = 1;
        }

        Optional<String> getScope() {
            if (this.scopeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopeBuildStage == 0) {
                this.scopeBuildStage = (byte)-1;
                Optional<String> computedValue = ImmutableOAuth2AuthenticatorConfig.this.getScopeInitialize();
                this.scope = Objects.requireNonNull(computedValue, "scope");
                this.scopeBuildStage = 1;
            }
            return this.scope;
        }

        boolean getTokenExchangeEnabled() {
            if (this.tokenExchangeEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenExchangeEnabledBuildStage == 0) {
                boolean computedValue;
                this.tokenExchangeEnabledBuildStage = (byte)-1;
                this.tokenExchangeEnabled = computedValue = ImmutableOAuth2AuthenticatorConfig.this.getTokenExchangeEnabledInitialize();
                this.tokenExchangeEnabledBuildStage = 1;
            }
            return this.tokenExchangeEnabled;
        }

        void tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.tokenExchangeEnabledBuildStage = 1;
        }

        TokenExchangeConfig getTokenExchangeConfig() {
            if (this.tokenExchangeConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenExchangeConfigBuildStage == 0) {
                this.tokenExchangeConfigBuildStage = (byte)-1;
                TokenExchangeConfig computedValue = ImmutableOAuth2AuthenticatorConfig.this.getTokenExchangeConfigInitialize();
                this.tokenExchangeConfig = Objects.requireNonNull(computedValue, "tokenExchangeConfig");
                this.tokenExchangeConfigBuildStage = 1;
            }
            return this.tokenExchangeConfig;
        }

        void tokenExchangeConfig(TokenExchangeConfig tokenExchangeConfig) {
            this.tokenExchangeConfig = tokenExchangeConfig;
            this.tokenExchangeConfigBuildStage = 1;
        }

        ImpersonationConfig getImpersonationConfig() {
            if (this.impersonationConfigBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.impersonationConfigBuildStage == 0) {
                this.impersonationConfigBuildStage = (byte)-1;
                ImpersonationConfig computedValue = ImmutableOAuth2AuthenticatorConfig.this.getImpersonationConfigInitialize();
                this.impersonationConfig = Objects.requireNonNull(computedValue, "impersonationConfig");
                this.impersonationConfigBuildStage = 1;
            }
            return this.impersonationConfig;
        }

        void impersonationConfig(ImpersonationConfig impersonationConfig) {
            this.impersonationConfig = impersonationConfig;
            this.impersonationConfigBuildStage = 1;
        }

        Duration getDefaultAccessTokenLifespan() {
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultAccessTokenLifespanBuildStage == 0) {
                this.defaultAccessTokenLifespanBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getDefaultAccessTokenLifespanInitialize();
                this.defaultAccessTokenLifespan = Objects.requireNonNull(computedValue, "defaultAccessTokenLifespan");
                this.defaultAccessTokenLifespanBuildStage = 1;
            }
            return this.defaultAccessTokenLifespan;
        }

        void defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = defaultAccessTokenLifespan;
            this.defaultAccessTokenLifespanBuildStage = 1;
        }

        Duration getDefaultRefreshTokenLifespan() {
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultRefreshTokenLifespanBuildStage == 0) {
                this.defaultRefreshTokenLifespanBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getDefaultRefreshTokenLifespanInitialize();
                this.defaultRefreshTokenLifespan = Objects.requireNonNull(computedValue, "defaultRefreshTokenLifespan");
                this.defaultRefreshTokenLifespanBuildStage = 1;
            }
            return this.defaultRefreshTokenLifespan;
        }

        void defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = defaultRefreshTokenLifespan;
            this.defaultRefreshTokenLifespanBuildStage = 1;
        }

        Duration getRefreshSafetyWindow() {
            if (this.refreshSafetyWindowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.refreshSafetyWindowBuildStage == 0) {
                this.refreshSafetyWindowBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getRefreshSafetyWindowInitialize();
                this.refreshSafetyWindow = Objects.requireNonNull(computedValue, "refreshSafetyWindow");
                this.refreshSafetyWindowBuildStage = 1;
            }
            return this.refreshSafetyWindow;
        }

        void refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = refreshSafetyWindow;
            this.refreshSafetyWindowBuildStage = 1;
        }

        Duration getPreemptiveTokenRefreshIdleTimeout() {
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == 0) {
                this.preemptiveTokenRefreshIdleTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getPreemptiveTokenRefreshIdleTimeoutInitialize();
                this.preemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(computedValue, "preemptiveTokenRefreshIdleTimeout");
                this.preemptiveTokenRefreshIdleTimeoutBuildStage = 1;
            }
            return this.preemptiveTokenRefreshIdleTimeout;
        }

        void preemptiveTokenRefreshIdleTimeout(Duration preemptiveTokenRefreshIdleTimeout) {
            this.preemptiveTokenRefreshIdleTimeout = preemptiveTokenRefreshIdleTimeout;
            this.preemptiveTokenRefreshIdleTimeoutBuildStage = 1;
        }

        Duration getBackgroundThreadIdleTimeout() {
            if (this.backgroundThreadIdleTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.backgroundThreadIdleTimeoutBuildStage == 0) {
                this.backgroundThreadIdleTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getBackgroundThreadIdleTimeoutInitialize();
                this.backgroundThreadIdleTimeout = Objects.requireNonNull(computedValue, "backgroundThreadIdleTimeout");
                this.backgroundThreadIdleTimeoutBuildStage = 1;
            }
            return this.backgroundThreadIdleTimeout;
        }

        void backgroundThreadIdleTimeout(Duration backgroundThreadIdleTimeout) {
            this.backgroundThreadIdleTimeout = backgroundThreadIdleTimeout;
            this.backgroundThreadIdleTimeoutBuildStage = 1;
        }

        Duration getAuthorizationCodeFlowTimeout() {
            if (this.authorizationCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorizationCodeFlowTimeoutBuildStage == 0) {
                this.authorizationCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getAuthorizationCodeFlowTimeoutInitialize();
                this.authorizationCodeFlowTimeout = Objects.requireNonNull(computedValue, "authorizationCodeFlowTimeout");
                this.authorizationCodeFlowTimeoutBuildStage = 1;
            }
            return this.authorizationCodeFlowTimeout;
        }

        void authorizationCodeFlowTimeout(Duration authorizationCodeFlowTimeout) {
            this.authorizationCodeFlowTimeout = authorizationCodeFlowTimeout;
            this.authorizationCodeFlowTimeoutBuildStage = 1;
        }

        Duration getDeviceCodeFlowTimeout() {
            if (this.deviceCodeFlowTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deviceCodeFlowTimeoutBuildStage == 0) {
                this.deviceCodeFlowTimeoutBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getDeviceCodeFlowTimeoutInitialize();
                this.deviceCodeFlowTimeout = Objects.requireNonNull(computedValue, "deviceCodeFlowTimeout");
                this.deviceCodeFlowTimeoutBuildStage = 1;
            }
            return this.deviceCodeFlowTimeout;
        }

        void deviceCodeFlowTimeout(Duration deviceCodeFlowTimeout) {
            this.deviceCodeFlowTimeout = deviceCodeFlowTimeout;
            this.deviceCodeFlowTimeoutBuildStage = 1;
        }

        Duration getDeviceCodeFlowPollInterval() {
            if (this.deviceCodeFlowPollIntervalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deviceCodeFlowPollIntervalBuildStage == 0) {
                this.deviceCodeFlowPollIntervalBuildStage = (byte)-1;
                Duration computedValue = ImmutableOAuth2AuthenticatorConfig.this.getDeviceCodeFlowPollIntervalInitialize();
                this.deviceCodeFlowPollInterval = Objects.requireNonNull(computedValue, "deviceCodeFlowPollInterval");
                this.deviceCodeFlowPollIntervalBuildStage = 1;
            }
            return this.deviceCodeFlowPollInterval;
        }

        void deviceCodeFlowPollInterval(Duration deviceCodeFlowPollInterval) {
            this.deviceCodeFlowPollInterval = deviceCodeFlowPollInterval;
            this.deviceCodeFlowPollIntervalBuildStage = 1;
        }

        ObjectMapper getObjectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                ObjectMapper computedValue = ImmutableOAuth2AuthenticatorConfig.this.getObjectMapperInitialize();
                this.objectMapper = Objects.requireNonNull(computedValue, "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.grantTypeBuildStage == -1) {
                attributes.add("grantType");
            }
            if (this.scopeBuildStage == -1) {
                attributes.add("scope");
            }
            if (this.tokenExchangeEnabledBuildStage == -1) {
                attributes.add("tokenExchangeEnabled");
            }
            if (this.tokenExchangeConfigBuildStage == -1) {
                attributes.add("tokenExchangeConfig");
            }
            if (this.impersonationConfigBuildStage == -1) {
                attributes.add("impersonationConfig");
            }
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                attributes.add("defaultAccessTokenLifespan");
            }
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                attributes.add("defaultRefreshTokenLifespan");
            }
            if (this.refreshSafetyWindowBuildStage == -1) {
                attributes.add("refreshSafetyWindow");
            }
            if (this.preemptiveTokenRefreshIdleTimeoutBuildStage == -1) {
                attributes.add("preemptiveTokenRefreshIdleTimeout");
            }
            if (this.backgroundThreadIdleTimeoutBuildStage == -1) {
                attributes.add("backgroundThreadIdleTimeout");
            }
            if (this.authorizationCodeFlowTimeoutBuildStage == -1) {
                attributes.add("authorizationCodeFlowTimeout");
            }
            if (this.deviceCodeFlowTimeoutBuildStage == -1) {
                attributes.add("deviceCodeFlowTimeout");
            }
            if (this.deviceCodeFlowPollIntervalBuildStage == -1) {
                attributes.add("deviceCodeFlowPollInterval");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            return "Cannot build OAuth2AuthenticatorConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="OAuth2AuthenticatorConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements OAuth2AuthenticatorConfig.Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long OPT_BIT_TOKEN_EXCHANGE_ENABLED = 1L;
        private long initBits = 1L;
        private long optBits;
        private URI issuerUrl;
        private URI tokenEndpoint;
        private URI authEndpoint;
        private URI deviceAuthEndpoint;
        private GrantType grantType;
        private String clientId;
        private Secret clientSecret;
        private Supplier<String> clientSecretSupplier;
        private String username;
        private Secret password;
        private Supplier<String> passwordSupplier;
        private List<String> scopes = new ArrayList<String>();
        private Map<String, String> extraRequestParameters = new LinkedHashMap<String, String>();
        private boolean tokenExchangeEnabled;
        private TokenExchangeConfig tokenExchangeConfig;
        private ImpersonationConfig impersonationConfig;
        private Duration defaultAccessTokenLifespan;
        private Duration defaultRefreshTokenLifespan;
        private Duration refreshSafetyWindow;
        private Duration preemptiveTokenRefreshIdleTimeout;
        private Duration backgroundThreadIdleTimeout;
        private Duration authorizationCodeFlowTimeout;
        private Integer authorizationCodeFlowWebServerPort;
        private Duration deviceCodeFlowTimeout;
        private Duration deviceCodeFlowPollInterval;
        private SSLContext sslContext;
        private ObjectMapper objectMapper;
        private ScheduledExecutorService executor;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(OAuth2AuthenticatorConfig instance) {
            Optional<Supplier<String>> passwordSupplierOptional;
            Optional<Secret> passwordOptional;
            Optional<String> usernameOptional;
            Optional<Supplier<String>> clientSecretSupplierOptional;
            Optional<URI> deviceAuthEndpointOptional;
            Optional<URI> authEndpointOptional;
            Optional<URI> tokenEndpointOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<URI> issuerUrlOptional = instance.getIssuerUrl();
            if (issuerUrlOptional.isPresent()) {
                this.issuerUrl(issuerUrlOptional);
            }
            if ((tokenEndpointOptional = instance.getTokenEndpoint()).isPresent()) {
                this.tokenEndpoint(tokenEndpointOptional);
            }
            if ((authEndpointOptional = instance.getAuthEndpoint()).isPresent()) {
                this.authEndpoint(authEndpointOptional);
            }
            if ((deviceAuthEndpointOptional = instance.getDeviceAuthEndpoint()).isPresent()) {
                this.deviceAuthEndpoint(deviceAuthEndpointOptional);
            }
            this.grantType(instance.getGrantType());
            this.clientId(instance.getClientId());
            Optional<Secret> clientSecretOptional = instance.getClientSecret();
            if (clientSecretOptional.isPresent()) {
                this.clientSecret(clientSecretOptional);
            }
            if ((clientSecretSupplierOptional = instance.getClientSecretSupplier()).isPresent()) {
                this.clientSecretSupplier(clientSecretSupplierOptional);
            }
            if ((usernameOptional = instance.getUsername()).isPresent()) {
                this.username(usernameOptional);
            }
            if ((passwordOptional = instance.getPassword()).isPresent()) {
                this.password(passwordOptional);
            }
            if ((passwordSupplierOptional = instance.getPasswordSupplier()).isPresent()) {
                this.passwordSupplier(passwordSupplierOptional);
            }
            this.addAllScopes(instance.getScopes());
            this.putAllExtraRequestParameters(instance.getExtraRequestParameters());
            this.tokenExchangeEnabled(instance.getTokenExchangeEnabled());
            this.tokenExchangeConfig(instance.getTokenExchangeConfig());
            this.impersonationConfig(instance.getImpersonationConfig());
            this.defaultAccessTokenLifespan(instance.getDefaultAccessTokenLifespan());
            this.defaultRefreshTokenLifespan(instance.getDefaultRefreshTokenLifespan());
            this.refreshSafetyWindow(instance.getRefreshSafetyWindow());
            this.preemptiveTokenRefreshIdleTimeout(instance.getPreemptiveTokenRefreshIdleTimeout());
            this.backgroundThreadIdleTimeout(instance.getBackgroundThreadIdleTimeout());
            this.authorizationCodeFlowTimeout(instance.getAuthorizationCodeFlowTimeout());
            OptionalInt authorizationCodeFlowWebServerPortOptional = instance.getAuthorizationCodeFlowWebServerPort();
            if (authorizationCodeFlowWebServerPortOptional.isPresent()) {
                this.authorizationCodeFlowWebServerPort(authorizationCodeFlowWebServerPortOptional);
            }
            this.deviceCodeFlowTimeout(instance.getDeviceCodeFlowTimeout());
            this.deviceCodeFlowPollInterval(instance.getDeviceCodeFlowPollInterval());
            Optional<SSLContext> sslContextOptional = instance.getSslContext();
            if (sslContextOptional.isPresent()) {
                this.sslContext(sslContextOptional);
            }
            this.objectMapper(instance.getObjectMapper());
            Optional<ScheduledExecutorService> executorOptional = instance.getExecutor();
            if (executorOptional.isPresent()) {
                this.executor(executorOptional);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder issuerUrl(URI issuerUrl) {
            this.issuerUrl = Objects.requireNonNull(issuerUrl, "issuerUrl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuerUrl(Optional<? extends URI> issuerUrl) {
            this.issuerUrl = issuerUrl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(Optional<? extends URI> tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authEndpoint(URI authEndpoint) {
            this.authEndpoint = Objects.requireNonNull(authEndpoint, "authEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authEndpoint(Optional<? extends URI> authEndpoint) {
            this.authEndpoint = authEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceAuthEndpoint(URI deviceAuthEndpoint) {
            this.deviceAuthEndpoint = Objects.requireNonNull(deviceAuthEndpoint, "deviceAuthEndpoint");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deviceAuthEndpoint(Optional<? extends URI> deviceAuthEndpoint) {
            this.deviceAuthEndpoint = deviceAuthEndpoint.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder grantType(GrantType grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecret(Secret clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<? extends Secret> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Supplier<String> clientSecretSupplier) {
            this.clientSecretSupplier = Objects.requireNonNull(clientSecretSupplier, "clientSecretSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecretSupplier(Optional<? extends Supplier<String>> clientSecretSupplier) {
            this.clientSecretSupplier = clientSecretSupplier.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder password(Secret password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(Optional<? extends Secret> password) {
            this.password = password.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder passwordSupplier(Supplier<String> passwordSupplier) {
            this.passwordSupplier = Objects.requireNonNull(passwordSupplier, "passwordSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder passwordSupplier(Optional<? extends Supplier<String>> passwordSupplier) {
            this.passwordSupplier = passwordSupplier.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScope(String element) {
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addScopes(String ... elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder scopes(Iterable<String> elements) {
            this.scopes.clear();
            return this.addAllScopes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllScopes(Iterable<String> elements) {
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraRequestParameter(String key, String value) {
            this.extraRequestParameters.put(Objects.requireNonNull(key, "extraRequestParameters key"), Objects.requireNonNull(value, value == null ? "extraRequestParameters value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtraRequestParameter(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.extraRequestParameters.put(Objects.requireNonNull(k, "extraRequestParameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "extraRequestParameters value for key: " + k : null));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder extraRequestParameters(Map<String, ? extends String> entries) {
            this.extraRequestParameters.clear();
            return this.putAllExtraRequestParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtraRequestParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.extraRequestParameters.put(Objects.requireNonNull(k, "extraRequestParameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "extraRequestParameters value for key: " + k : null));
            }
            return this;
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tokenExchangeConfig(TokenExchangeConfig tokenExchangeConfig) {
            this.tokenExchangeConfig = Objects.requireNonNull(tokenExchangeConfig, "tokenExchangeConfig");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder impersonationConfig(ImpersonationConfig impersonationConfig) {
            this.impersonationConfig = Objects.requireNonNull(impersonationConfig, "impersonationConfig");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = Objects.requireNonNull(defaultAccessTokenLifespan, "defaultAccessTokenLifespan");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = Objects.requireNonNull(defaultRefreshTokenLifespan, "defaultRefreshTokenLifespan");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = Objects.requireNonNull(refreshSafetyWindow, "refreshSafetyWindow");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder preemptiveTokenRefreshIdleTimeout(Duration preemptiveTokenRefreshIdleTimeout) {
            this.preemptiveTokenRefreshIdleTimeout = Objects.requireNonNull(preemptiveTokenRefreshIdleTimeout, "preemptiveTokenRefreshIdleTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder backgroundThreadIdleTimeout(Duration backgroundThreadIdleTimeout) {
            this.backgroundThreadIdleTimeout = Objects.requireNonNull(backgroundThreadIdleTimeout, "backgroundThreadIdleTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowTimeout(Duration authorizationCodeFlowTimeout) {
            this.authorizationCodeFlowTimeout = Objects.requireNonNull(authorizationCodeFlowTimeout, "authorizationCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowWebServerPort(int authorizationCodeFlowWebServerPort) {
            this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authorizationCodeFlowWebServerPort(OptionalInt authorizationCodeFlowWebServerPort) {
            this.authorizationCodeFlowWebServerPort = authorizationCodeFlowWebServerPort.isPresent() ? Integer.valueOf(authorizationCodeFlowWebServerPort.getAsInt()) : null;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceCodeFlowTimeout(Duration deviceCodeFlowTimeout) {
            this.deviceCodeFlowTimeout = Objects.requireNonNull(deviceCodeFlowTimeout, "deviceCodeFlowTimeout");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder deviceCodeFlowPollInterval(Duration deviceCodeFlowPollInterval) {
            this.deviceCodeFlowPollInterval = Objects.requireNonNull(deviceCodeFlowPollInterval, "deviceCodeFlowPollInterval");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sslContext(SSLContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sslContext(Optional<? extends SSLContext> sslContext) {
            this.sslContext = sslContext.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executor(ScheduledExecutorService executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(Optional<? extends ScheduledExecutorService> executor) {
            this.executor = executor.orElse(null);
            return this;
        }

        @Override
        public ImmutableOAuth2AuthenticatorConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOAuth2AuthenticatorConfig(this);
        }

        private boolean tokenExchangeEnabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build OAuth2AuthenticatorConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

