/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.http;

import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.OpentelemetryTracing;
import com.dataiku.dss.shadelib.org.projectnessie.client.rest.NessieHttpResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClients.class);

    private HttpClients() {
    }

    static HttpClient buildClient(boolean enableTracing, HttpClient.Builder clientBuilder) {
        if (enableTracing) {
            HttpClients.addTracing(clientBuilder);
        }
        clientBuilder.addResponseFilter(new NessieHttpResponseFilter());
        return clientBuilder.build();
    }

    private static void addTracing(HttpClient.Builder httpClient) {
        try {
            OpentelemetryTracing.addTracing(httpClient);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("Failed to initialize tracing, the opentracing libraries are probably missing.", (Throwable)e);
        }
    }
}

