/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.projectnessie.client.rest.v1;

import com.dataiku.dss.shadelib.org.projectnessie.api.v1.http.HttpNamespaceApi;
import com.dataiku.dss.shadelib.org.projectnessie.api.v1.params.MultipleNamespacesParams;
import com.dataiku.dss.shadelib.org.projectnessie.api.v1.params.NamespaceParams;
import com.dataiku.dss.shadelib.org.projectnessie.api.v1.params.NamespaceUpdate;
import com.dataiku.dss.shadelib.org.projectnessie.client.http.HttpClient;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotEmptyException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieNamespaceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.error.NessieReferenceNotFoundException;
import com.dataiku.dss.shadelib.org.projectnessie.model.GetNamespacesResponse;
import com.dataiku.dss.shadelib.org.projectnessie.model.Namespace;
import jakarta.validation.constraints.NotNull;

class RestV1NamespaceClient
implements HttpNamespaceApi {
    private final HttpClient client;

    RestV1NamespaceClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public Namespace createNamespace(@javax.validation.constraints.NotNull @NotNull NamespaceParams params, @javax.validation.constraints.NotNull @NotNull Namespace namespace) throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).put(namespace).readEntity(Namespace.class);
    }

    @Override
    public void deleteNamespace(@javax.validation.constraints.NotNull @NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieNamespaceNotEmptyException, NessieReferenceNotFoundException {
        this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).delete();
    }

    @Override
    public Namespace getNamespace(@javax.validation.constraints.NotNull @NotNull NamespaceParams params) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).get().readEntity(Namespace.class);
    }

    @Override
    public GetNamespacesResponse getNamespaces(@javax.validation.constraints.NotNull @NotNull MultipleNamespacesParams params) throws NessieReferenceNotFoundException {
        return this.client.newRequest().path("namespaces/{ref}").resolveTemplate("ref", params.getRefName()).queryParam("name", null != params.getNamespace() ? params.getNamespace().toPathString() : null).queryParam("hashOnRef", params.getHashOnRef()).get().readEntity(GetNamespacesResponse.class);
    }

    @Override
    public void updateProperties(@javax.validation.constraints.NotNull @NotNull NamespaceParams params, @javax.validation.constraints.NotNull @NotNull NamespaceUpdate namespaceUpdate) throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        this.client.newRequest().path("namespaces/namespace/{ref}/{name}").resolveTemplate("ref", params.getRefName()).resolveTemplate("name", params.getNamespace().toPathString()).queryParam("hashOnRef", params.getHashOnRef()).post(namespaceUpdate);
    }
}

