/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.jwt;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.jwt.BadTokenException;
import com.dataiku.dip.security.jwt.JWTError;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class JWTClaimsSetVerifierFactory {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private static DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
    public static final String SSO_OPENID_TIME_DRIFT_ALLOWANCE_SEC = "dku.sso.time.drift.allowance";

    public static JWTClaimsSetVerifierMulti createJwtClaimsSetVerifierMulti() {
        return new JWTClaimsSetVerifierMulti();
    }

    public static JWTClaimsSetVerifier<SecurityContext> createExpVerifier() {
        return (jwtClaimsSet, securityContext) -> {
            if (jwtClaimsSet.getExpirationTime() == null) {
                logger.errorV("The token has no expiration time", new Object[0]);
                throw new BadTokenException(JWTError.ERR_JWT_NO_EXPIRED_TIME, "No expired time in access token");
            }
            Instant now = Instant.now();
            if (jwtClaimsSet.getExpirationTime().toInstant().isBefore(now)) {
                logger.errorV("The token has an expiration time '%s' < now(%s)", new Object[]{dateFormat.format(jwtClaimsSet.getExpirationTime().toInstant()), dateFormat.format(now)});
                throw new BadTokenException(JWTError.ERR_JWT_EXPIRED, "Expired access token");
            }
        };
    }

    public static JWTClaimsSetVerifier<SecurityContext> createIssueAtTimeVerifier() {
        return (jwtClaimsSet, securityContext) -> {
            Instant now = Instant.now();
            int timeDriftAllowance = Integer.parseInt(DKUApp.getProperty(SSO_OPENID_TIME_DRIFT_ALLOWANCE_SEC, "5"));
            if (jwtClaimsSet.getIssueTime() != null && jwtClaimsSet.getIssueTime().toInstant().isAfter(now.plus((long)timeDriftAllowance, ChronoUnit.SECONDS))) {
                logger.errorV("The token has an issuer time '%s' > now(%s) with a drift allowance of %s sec(s)", new Object[]{dateFormat.format(jwtClaimsSet.getIssueTime().toInstant()), dateFormat.format(now), timeDriftAllowance});
                throw new BadTokenException(JWTError.ERR_JWT_IAT_INVALID, "Invalid IAT for access token");
            }
        };
    }

    public static JWTClaimsSetVerifier<SecurityContext> createNotBeforeTimeVerifier() {
        return (jwtClaimsSet, securityContext) -> {
            Instant now = Instant.now();
            if (jwtClaimsSet.getNotBeforeTime() != null && jwtClaimsSet.getNotBeforeTime().toInstant().isAfter(now)) {
                logger.errorV("The token is marked to be not consumed before time '%s' < now(%s)", new Object[]{dateFormat.format(jwtClaimsSet.getIssueTime().toInstant()), dateFormat.format(now)});
                throw new BadTokenException(JWTError.ERR_JWT_NBT_INVALID, "Invalid NBT for access token");
            }
        };
    }

    public static JWTClaimsSetVerifier<SecurityContext> createIssuerVerifier(String issuer) {
        return (jwtClaimsSet, securityContext) -> {
            if (!issuer.equals(jwtClaimsSet.getIssuer())) {
                logger.errorV("Invalid issuer '" + jwtClaimsSet.getIssuer() + "', expecting '" + issuer + "'", new Object[0]);
                throw new BadTokenException(JWTError.ERR_JWT_INVALID_ISSUER, "Invalid issuer '" + jwtClaimsSet.getIssuer() + "', expecting '" + issuer + "'");
            }
        };
    }

    public static JWTClaimsSetVerifier<SecurityContext> createAudienceVerifier(String audience) {
        return (jwtClaimsSet, securityContext) -> {
            if (!jwtClaimsSet.getAudience().contains(audience)) {
                logger.errorV("Invalid audiences '" + String.join((CharSequence)",", jwtClaimsSet.getAudience()) + "', expecting '" + audience + "'", new Object[0]);
                throw new BadTokenException(JWTError.ERR_JWT_INVALID_AUDIENCE, "Invalid audiences '" + String.join((CharSequence)",", jwtClaimsSet.getAudience()) + "', expecting '" + audience + "'");
            }
        };
    }

    public static class JWTClaimsSetVerifierMulti
    implements JWTClaimsSetVerifier<SecurityContext> {
        private List<JWTClaimsSetVerifier<SecurityContext>> verifiers = new ArrayList<JWTClaimsSetVerifier<SecurityContext>>();

        public JWTClaimsSetVerifierMulti add(JWTClaimsSetVerifier<SecurityContext> jwtClaimsSetVerifier) {
            this.verifiers.add(jwtClaimsSetVerifier);
            return this;
        }

        public void verify(JWTClaimsSet jwtClaimsSet, SecurityContext securityContext) throws BadJWTException {
            for (JWTClaimsSetVerifier<SecurityContext> jwtClaimsSetVerifier : this.verifiers) {
                jwtClaimsSetVerifier.verify(jwtClaimsSet, securityContext);
            }
        }
    }
}

