/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public final class RunLogsUtils {
    public static String INITIAL_RUN_ID = "initial";
    private static final DateTimeFormatter defaultRunIdFormatter = DateTimeFormat.forPattern((String)"'run_'yyyy-MM-dd-HH-mm-ss-SSS").withZone(DateTimeZone.getDefault());
    private static final Pattern defaultRunIdPattern = Pattern.compile("^" + INITIAL_RUN_ID + "|^run_[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{3}");
    static DKULogger logger = DKULogger.getLogger((String)"dku.runlogs");

    public static RunLogsList listLogs(File runBaseFolder, String activeRunId, Pattern runFolderPattern, DateTimeFormatter runFolderDateTimeFormatter) {
        RunLogsList runLogsList = new RunLogsList();
        ArrayList runs = Lists.newArrayList();
        if (runBaseFolder.exists() && runBaseFolder.isDirectory()) {
            String logSubject = runBaseFolder.getParentFile().getName() + "/" + runBaseFolder.getName();
            List<String> runIds = new ArrayList<String>();
            File[] runBaseDirFiles = runBaseFolder.listFiles();
            if (runBaseDirFiles != null) {
                for (File f : runBaseDirFiles) {
                    if (!f.isDirectory() || runFolderPattern == null || !runFolderPattern.matcher(f.getName()).matches() || !f.canExecute() || !f.canRead()) continue;
                    runIds.add(f.getName());
                }
                logger.infoV("Listing run folders of %s: %d found", new Object[]{logSubject, runIds.size()});
            } else {
                logger.warnV("Unable to list run folders of %s", new Object[]{logSubject});
            }
            runIds.sort(Comparator.reverseOrder());
            runLogsList.runsCount = runIds.size();
            if (runIds.size() > 50) {
                logger.infoV("Keeping 50 most recent runs of %s", new Object[]{logSubject});
                runIds = runIds.subList(0, 50);
            }
            for (String runId : runIds) {
                RunLogs run = new RunLogs();
                run.runId = runId;
                run.epoch = runFolderDateTimeFormatter == null || runId.startsWith(INITIAL_RUN_ID) ? 0L : runFolderDateTimeFormatter.parseMillis(runId);
                run.logFiles = new ArrayList<RunLogFile>();
                File runDir = new File(runBaseFolder, runId);
                File[] runDirFiles = runDir.listFiles();
                if (runDirFiles != null) {
                    for (File f : runDirFiles) {
                        if (!f.isFile() || !f.getName().endsWith(".log") || !f.canRead()) continue;
                        RunLogFile logFile = new RunLogFile();
                        logFile.filename = f.getName();
                        logFile.size = f.length();
                        run.logFiles.add(logFile);
                    }
                } else {
                    logger.warnV("Unable to list run files of %s/%s", new Object[]{logSubject, runId});
                }
                runs.add(run);
            }
        }
        runLogsList.runs = runs;
        runLogsList.activeRunId = activeRunId;
        return runLogsList;
    }

    public static RunLogsList listLogs(File runBaseFolder, String activeRunId) {
        return RunLogsUtils.listLogs(runBaseFolder, activeRunId, defaultRunIdPattern, defaultRunIdFormatter);
    }

    public static class RunLogsList {
        public String activeRunId;
        public List<RunLogs> runs;
        public int runsCount = 0;
    }

    public static class RunLogs {
        public String runId;
        public List<RunLogFile> logFiles;
        public long epoch = 0L;
    }

    public static class RunLogFile {
        public String filename;
        public long size;
    }
}

