/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.datasets.DatasetSelectionToMemTable;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.services.DatasetStreamService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.RefreshTableService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.workspaces.Workspace;
import com.dataiku.dip.workspaces.WorkspacesDAO;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/workspaces"})
public class PublicAPIWorkspacesController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private WorkspacesDAO workspacesDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetStreamService datasetStreamService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DataService dataService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private RefreshTableService refreshTableService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDBService;
    private static final String AT_MOST_ONE_TYPE = "At most one of the following field must be provided: 'reference', 'appId', 'story', 'htmlLink'";
    private static final String AT_LEAST_ONE_TYPE = "At least one of the following field must be provided: 'reference', 'appId', 'story', 'htmlLink'";

    @AuditedCall(value={"msgType", "workspaces-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WorkspaceSettings> listWorkspaces(HttpServletRequest req) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            Function<Workspace, WorkspaceSettings> extractSettings = workspace -> this.extractSettings(authCtx, (Workspace)workspace);
            List<WorkspaceSettings> list = this.workspacesService.listAccessibleWorkspacesUnsafe(authCtx).stream().map(extractSettings).collect(Collectors.toList());
            return list;
        }
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage createWorkspace(HttpServletRequest req, HttpServletResponse resp, @RequestBody WorkspaceSettings workspace) throws Exception {
        this.require(StringUtils.isNotBlank((String)workspace.workspaceKey), "Required field 'workspaceKey' is missing");
        this.require(WorkspacesService.isValidWorkspaceKey((String)workspace.workspaceKey), "Field 'workspaceKey' contains invalid character");
        this.require(StringUtils.isNotBlank((String)workspace.displayName), "Required field 'displayName' is missing");
        this.checkPermissionsAreValid(workspace.permissions);
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            if (authCtx.getAuthSource() == AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT || !authCtx.getPermissions().mayCreateWorkspaces()) {
                throw new SecurityException("You may not create new workspaces");
            }
            if (this.workspacesService.hasWorkspace(workspace.workspaceKey)) {
                throw new DKUControllerBase.MalformedRequestException(String.format("Workspace %s already exists", workspace.workspaceKey));
            }
            this.workspacesService.createWorkspace((AuthCtx)authCtx, PublicAPIWorkspacesController.fromSettings(workspace));
            t.commit("Created workspace " + workspace.workspaceKey);
            this.auditTrailService.generic("workspace-create").with("workspaceKey", workspace.workspaceKey).emit();
        }
        return new PublicAPIControllerBase.ResponseMessage("Created workspace " + workspace.workspaceKey);
    }

    @AuditedCall(value={"msgType", "workspace-delete", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/{workspaceKey:.+}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage deleteWorkspace(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey) throws Exception {
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.workspacePermissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.ADMIN});
            this.workspacesService.deleteWorkspace(workspaceKey);
            t.commit("Deleted workspace " + workspaceKey);
        }
        return new PublicAPIControllerBase.ResponseMessage("Deleted workspace " + workspaceKey);
    }

    @AuditedCall(value={"msgType", "workspace-get-settings", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/{workspaceKey:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public WorkspaceSettings getWorkspaceSettings(HttpServletRequest req, @PathVariable String workspaceKey) throws Exception {
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            assert (authCtx != null);
            this.workspacePermissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.READ});
            WorkspaceSettings workspaceSettings = this.extractSettings(authCtx, this.workspacesService.getWorkspace(authCtx, workspaceKey, true, false));
            return workspaceSettings;
        }
    }

    @AuditedCall(value={"msgType", "workspace-save-settings", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/{workspaceKey:.+}"}, method={RequestMethod.PUT})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage saveWorkspaceSettings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @RequestBody WorkspaceSettings settings) throws Exception {
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        this.require(StringUtils.isNotBlank((String)settings.displayName), "Required field 'displayName' is missing");
        this.checkPermissionsAreValid(settings.permissions);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            Workspace workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey);
            if (workspace == null) {
                throw new DKUControllerBase.MalformedRequestException(String.format("Workspace %s does not exist", workspaceKey));
            }
            this.workspacePermissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.ADMIN});
            workspace.displayName = settings.displayName;
            workspace.color = settings.color;
            workspace.description = settings.description;
            workspace.permissions = settings.permissions;
            this.workspacesService.updateWorkspace(authCtx, workspace);
            t.commit("Updated workspace settings for " + workspaceKey);
        }
        return new PublicAPIControllerBase.ResponseMessage("Updated workspace " + workspaceKey);
    }

    @AuditedCall(value={"msgType", "workspace-objects-list", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/{workspaceKey}/objects"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Workspace.WorkspaceObject> listWorkspaceObjects(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey) throws Exception {
        Workspace workspace;
        AuthCtx authCtx;
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.workspacePermissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.READ});
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey, false, true);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspace);
        return workspace.workspaceObjects;
    }

    @AuditedCall(value={"msgType", "workspace-object-get", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/objects/{workspaceObjectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Workspace.WorkspaceObject getWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId) throws Exception {
        Workspace workspace;
        AuthCtx authCtx;
        this.require(StringUtils.isNotBlank((String)workspaceObjectId), "required 'workspaceObjectId' path parameter.");
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.workspacePermissionsService.checkWorkspacePrivileges(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.READ});
            workspace = this.workspacesService.getWorkspace(authCtx, workspaceKey, false, true);
        }
        this.workspacesService.enrichWithInterest_NT(authCtx, workspaceKey, (Collection)workspace.workspaceObjects);
        Workspace.WorkspaceObject objectWithId = WorkspacesService.findObjectWithId((Workspace)workspace, (String)workspaceObjectId);
        if (objectWithId == null) {
            throw new NotFoundException(String.format("Object with id:%s cannot be found in the workspace:%s", workspaceObjectId, workspaceKey));
        }
        return objectWithId;
    }

    @AuditedCall(value={"msgType", "workspace-add-object", "workspaceKey", "${workspaceKey}"})
    @RequestMapping(value={"/{workspaceKey}/objects"}, method={RequestMethod.POST})
    @ResponseBody
    public WorkspaceAddObjectResponse addWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @RequestBody Workspace.WorkspaceObject workspaceObject) throws Exception {
        Workspace workspace;
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        this.checkWorkspaceObject(workspaceObject);
        WorkspaceAddObjectResponse result = new WorkspaceAddObjectResponse();
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (Transaction ignored = this.transactionService.beginRead();){
            if (WorkspacesService.needsShareToWorkspaceRights((Workspace.WorkspaceObject)workspaceObject)) {
                if (!authCtx.getPermissions().mayShareToWorkspaces()) {
                    throw new SecurityException("You may not share objects to workspaces");
                }
                if (workspaceObject.reference != null) {
                    this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, workspaceObject.reference.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.SHARE_TO_WORKSPACES});
                }
            }
            this.workspacePermissionsService.checkWorkspacePrivileges((AuthCtx)authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.WRITE});
            workspace = this.workspacesDAO.getMandatory(workspaceKey);
        }
        this.workspacesService.createDatastories((AuthCtx)authCtx, workspace, Collections.singletonList(workspaceObject));
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            result.id = this.workspacesService.addObject((AuthCtx)authCtx, workspaceKey, workspaceObject);
            t.commit("Added object to workspace " + workspaceKey);
        }
        return result;
    }

    @AuditedCall(value={"msgType", "workspace-remove-object", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/objects/{workspaceObjectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage removeWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId) throws Exception {
        List<Workspace.WorkspaceObject> objectsToRemove;
        Workspace workspace;
        this.require(StringUtils.isNotBlank((String)workspaceObjectId), "required 'workspaceObjectId' path parameter.");
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction ignored = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            this.workspacesService.checkPerm((AuthCtx)authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.WRITE});
            workspace = this.workspacesDAO.getMandatory(workspaceKey);
            objectsToRemove = Collections.singletonList(WorkspacesService.findObjectWithId((Workspace)workspace, (String)workspaceObjectId));
        }
        this.workspacesService.deleteDatastories((AuthCtx)authCtx, workspace, objectsToRemove);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            boolean removed = this.workspacesService.removeObjects((AuthCtx)authCtx, workspace, objectsToRemove);
            if (!removed) {
                throw new NotFoundException(String.format("Workspace object %s cannot be found in workspace %s", workspaceObjectId, workspaceKey));
            }
            t.commit("Removed object from workspace " + workspaceKey);
        }
        return new PublicAPIControllerBase.ResponseMessage("Removed workspace object " + workspaceObjectId);
    }

    @AuditedCall(value={"msgType", "workspace-edit-object", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/objects/{workspaceObjectId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public PublicAPIControllerBase.ResponseMessage editWorkspaceObject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId, @RequestBody Workspace.WorkspaceObject newData) throws Exception {
        Workspace workspace;
        this.require(StringUtils.isNotBlank((String)workspaceObjectId), "required 'workspaceObjectId' path parameter.");
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey_NT(req);
        try (RWTransaction ignored = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            this.workspacesService.checkPerm((AuthCtx)authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.WRITE});
            workspace = this.workspacesDAO.getMandatory(workspaceKey);
        }
        newData.id = workspaceObjectId;
        this.workspacesService.updateDatastory(authCtx, workspace, newData);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)authCtx);){
            this.workspacesService.updateWorkspaceObject(authCtx, workspace, newData);
            t.commit("Edited object from workspace " + workspaceKey);
        }
        return new PublicAPIControllerBase.ResponseMessage("Edited workspace object " + workspaceObjectId);
    }

    @AuditedCall(value={"msgType", "workspace-dataset-get", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/datasets/{workspaceObjectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public WorkspaceDatasetInfo getDatasetInfo(HttpServletRequest req, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId) throws Exception {
        Dataset dataset;
        NavigatorService.DatasetFullInfo datasetFullInfo;
        AuthCtx authCtx;
        this.require(StringUtils.isNotBlank((String)workspaceObjectId), "required 'workspaceObjectId' path parameter.");
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.workspacesService.checkPerm(authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.READ});
            TaggableObjectsService.TaggableObjectRef datasetReference = this.getDatasetReferenceAndCheckRights(authCtx, workspaceKey, workspaceObjectId);
            datasetFullInfo = new NavigatorService.DatasetFullInfo((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(datasetReference.projectKey, datasetReference.id));
            dataset = Dataset.fromSerializedUnsafe((SerializedDataset)datasetFullInfo.dataset);
        }
        CodeBasedRecipeDatasetInfoHelper.LocationInfo datasetLocationInfo = new CodeBasedRecipeDatasetInfoHelper().getDatasetLocationInfo_NT(authCtx, dataset, false);
        this.navigatorService.addInfo_NT((NavigatorService.TaggableObjectFullInfo)datasetFullInfo, authCtx);
        ReadOnlyJobsInternalDB.ObjectBuild latestSuccessfulBuild = this.jobsDBService.getLatestSuccessfulBuildForObject(datasetFullInfo.dataset.projectKey, datasetFullInfo.dataset.getId());
        return new WorkspaceDatasetInfo(datasetFullInfo, datasetLocationInfo, latestSuccessfulBuild);
    }

    @AuditedCall(value={"msgType", "workspace-dataset-read-data", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/datasets/{workspaceObjectId}/data"}, method={RequestMethod.POST})
    public void getData(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId, @RequestBody DatasetReadAPIUtils.DatasetStreamingRequestSettings settings) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        this.require(StringUtils.isNotBlank((String)workspaceObjectId), "required 'workspaceObjectId' path parameter.");
        this.require(StringUtils.isNotBlank((String)workspaceKey), "required 'workspaceKey' path parameter.");
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            TaggableObjectsService.TaggableObjectRef datasetReference = this.getDatasetReferenceAndCheckRights(authCtx, workspaceKey, workspaceObjectId);
            dataset = this.datasetAccessService.getMandatory(datasetReference.projectKey, datasetReference.id);
        }
        this.datasetStreamService.doStream(resp, authCtx, dataset, settings.format, settings.formatParams, settings.columns, settings.partitions, settings.filterExpression, settings.sampling, settings.readSessionId);
    }

    @AuditedCall(value={"msgType", "workspace-dataset-get", "workspaceKey", "${workspaceKey}", "workspaceObjectId", "${workspaceObjectId}"})
    @RequestMapping(value={"/{workspaceKey}/datasets/{workspaceObjectId}/meanings"}, method={RequestMethod.POST})
    public void getMeanings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String workspaceKey, @PathVariable String workspaceObjectId, @RequestBody(required=false) MeaningsRequest request) throws Exception {
        RefreshTableService.MeaningsFutureThread ft;
        try (Transaction ignored = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.workspacesService.checkPerm((AuthCtx)authCtx, workspaceKey, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.READ});
            TaggableObjectsService.TaggableObjectRef datasetReference = this.getDatasetReferenceAndCheckRights((AuthCtx)authCtx, workspaceKey, workspaceObjectId);
            Dataset ds = this.datasetAccessService.getMandatory(datasetReference.projectKey, datasetReference.id);
            SerializedShakerScript script = this.buildShakerScript(datasetReference, request);
            ft = this.refreshTableService.getMeaningsFuture(authCtx, ds, script, Boolean.TRUE.equals(request.allowCache), request.nbCols, request.filters, request.requestedSampleId);
        }
        PublicAPIWorkspacesController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.runFuture((FutureThreadBase)ft, 2000L, (TypeToken)new TypeToken<FutureResponse<RefreshTableService.MeaningsResponse>>(){}));
    }

    private TaggableObjectsService.TaggableObjectRef getDatasetReferenceAndCheckRights(AuthCtx authCtx, String workspaceKey, String workspaceObjectId) throws IOException, DKUSecurityException {
        Workspace workspace = this.workspacesService.getRawWorkspaceUnsafe(workspaceKey);
        Workspace.WorkspaceObject workspaceObject = WorkspacesService.findDatasetWithId((Workspace)workspace, (String)workspaceObjectId);
        if (workspaceObject == null) {
            throw new NotFoundException("Cannot find workspace object of type DATASET with id: " + workspaceObjectId);
        }
        assert (workspaceObject.reference != null);
        this.permissionsService.checkReadDashboardPermission(authCtx, workspaceObject.reference.projectKey, ITaggingService.TaggableType.DATASET, workspaceObject.reference.id);
        return workspaceObject.reference;
    }

    private SerializedShakerScript buildShakerScript(TaggableObjectsService.TaggableObjectRef reference, MeaningsRequest request) {
        SerializedShakerScript script = new SerializedShakerScript();
        if (request == null) {
            request = new MeaningsRequest();
        }
        script.origin = this.getScriptOrigin(request);
        script.contextProjectKey = reference.projectKey;
        if (request.selection != null) {
            script.explorationSampling.selection = request.selection;
        }
        return script;
    }

    private SerializedShakerScript.ShakerOrigin getScriptOrigin(MeaningsRequest request) {
        if (Objects.equals(request.origin, "")) {
            return null;
        }
        if (SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE.name().equalsIgnoreCase(request.origin) || request.origin == null) {
            return SerializedShakerScript.ShakerOrigin.DATASET_EXPLORE;
        }
        throw new IllegalArgumentException("origin field can only be empty, null or 'DATASET_EXPLORE'");
    }

    private void checkPermissionsAreValid(List<BasePermissions.PermissionItem> permissions) {
        for (BasePermissions.PermissionItem permissionItem : permissions) {
            if (permissionItem == null) continue;
            String msg = "Need exactly one of these fields: 'group', 'user', 'pendingUserEmail'.";
            this.require(permissionItem.group != null ^ permissionItem.user != null ^ permissionItem.pendingUserEmail != null && (permissionItem.group == null || permissionItem.user == null), msg);
            if (permissionItem.group != null) {
                this.require(!permissionItem.group.isEmpty(), "Required field 'group' is empty.");
                continue;
            }
            if (permissionItem.user != null) {
                this.require(!permissionItem.user.isEmpty(), "Required field 'user' is empty.");
                continue;
            }
            this.require(permissionItem.pendingUserEmail.indexOf(64) > 0, "Permission field 'pendingUserEmail' must be a valid email");
        }
    }

    @VisibleForTesting
    void checkWorkspaceObject(Workspace.WorkspaceObject object) {
        if (object.reference != null) {
            this.require(object.appId == null && object.htmlLink == null && object.story == null, AT_MOST_ONE_TYPE);
            this.require(StringUtils.isNotBlank((String)object.reference.projectKey), "Field 'projectKey' must be provided for object references");
            this.require(object.reference.type != null, "Field 'type' must be provided for object references");
            this.require(StringUtils.isNotBlank((String)object.reference.id), "Field 'id' must be provided for object references");
        } else if (object.appId != null) {
            this.require(object.htmlLink == null && object.story == null, AT_MOST_ONE_TYPE);
            this.require(StringUtils.isNotBlank((String)object.appId), "Field 'appId' cannot be blank");
        } else if (object.story != null) {
            this.require(object.htmlLink == null, AT_MOST_ONE_TYPE);
            this.require(StringUtils.isNotBlank((String)object.story.title), "Field 'title' must be provided for story");
            this.require(object.story.references.size() > 0, "Field 'references' must be provided for story");
        } else if (object.htmlLink != null) {
            this.require(StringUtils.isNotBlank((String)object.htmlLink.url), "Field 'url' must be provided for HTML links");
        } else {
            throw new DKUControllerBase.MalformedRequestException(AT_LEAST_ONE_TYPE);
        }
    }

    private WorkspaceSettings extractSettings(AuthCtx authCtx, Workspace workspace) {
        boolean withPermissions = false;
        try {
            withPermissions = this.workspacePermissionsService.hasWorkspacePrivileges(authCtx, workspace, new Privileges.WorkspaceLevelPrivilegeType[]{Privileges.WorkspaceLevelPrivilegeType.ADMIN});
        }
        catch (DKUSecurityException e) {
            logger.warn((Object)"Cannot test if user is workspace admin", (Throwable)e);
        }
        WorkspaceSettings settings = new WorkspaceSettings();
        settings.workspaceKey = workspace.workspaceKey;
        settings.displayName = workspace.displayName;
        settings.color = workspace.color;
        settings.description = workspace.description;
        settings.permissions = withPermissions ? workspace.permissions : null;
        settings.currentUserPermissions = workspace.currentUserPermissions;
        settings.currentUserMayEditStories = this.licenseEnforcementService.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteStories;
        settings.currentUserMayReadStories = this.licenseEnforcementService.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReadStories;
        return settings;
    }

    private static Workspace fromSettings(WorkspaceSettings settings) {
        Workspace workspace = new Workspace();
        workspace.workspaceKey = settings.workspaceKey;
        workspace.displayName = settings.displayName;
        workspace.color = settings.color;
        workspace.description = settings.description;
        workspace.permissions = settings.permissions;
        return workspace;
    }

    public static class WorkspaceSettings {
        public String workspaceKey;
        public String displayName;
        public String color;
        public String description;
        public List<BasePermissions.PermissionItem> permissions = new ArrayList<BasePermissions.PermissionItem>();
        public BasePermissions.Permissions currentUserPermissions;
        public boolean currentUserMayEditStories;
        public boolean currentUserMayReadStories;
    }

    public static class WorkspaceAddObjectResponse {
        public String id;
    }

    public static class WorkspaceDatasetInfo {
        public String projectKey;
        public String name;
        public String type;
        public List<String> tags;
        public Schema schema;
        public String formatType;
        public CodeBasedRecipeDatasetInfoHelper.LocationInfoType connectionInfoType;
        public Map<String, Object> connectionInfo;
        public boolean managed;
        public VersionTag versionTag;
        public ObjectBuild latestSuccessfulBuild;

        public WorkspaceDatasetInfo(NavigatorService.DatasetFullInfo datasetFullInfo, CodeBasedRecipeDatasetInfoHelper.LocationInfo datasetLocationInfo, ReadOnlyJobsInternalDB.ObjectBuild latestSuccessfulBuild) {
            long versionTagLastModifiedOn;
            this.type = datasetFullInfo.dataset.type;
            this.formatType = datasetFullInfo.dataset.formatType;
            this.schema = datasetFullInfo.dataset.getSchema();
            this.tags = datasetFullInfo.dataset.tags;
            this.name = datasetFullInfo.dataset.name;
            this.projectKey = datasetFullInfo.dataset.projectKey;
            this.managed = datasetFullInfo.dataset.managed;
            this.connectionInfo = datasetLocationInfo.info;
            this.connectionInfoType = datasetLocationInfo.locationInfoType;
            this.versionTag = datasetFullInfo.dataset.versionTag;
            this.latestSuccessfulBuild = latestSuccessfulBuild != null ? new ObjectBuild(latestSuccessfulBuild) : null;
            long l = versionTagLastModifiedOn = this.versionTag != null ? datasetFullInfo.dataset.versionTag.getLastModifiedOn() : 0L;
            if (datasetFullInfo.versioning.lastModifiedOn > versionTagLastModifiedOn) {
                this.versionTag = new VersionTag(datasetFullInfo.versioning.lastModifiedBy.login, datasetFullInfo.versioning.lastModifiedOn, this.versionTag != null ? this.versionTag.versionNumber : 1L);
            }
        }

        public static class ObjectBuild {
            public long buildEndTime;

            public ObjectBuild(ReadOnlyJobsInternalDB.ObjectBuild lastBuild) {
                this.buildEndTime = lastBuild.buildEndTime;
            }
        }
    }

    public static class MeaningsRequest {
        public DatasetSelectionToMemTable selection;
        public Boolean allowCache = Boolean.FALSE;
        public FilterRequest filters;
        public String requestedSampleId;
        public Integer nbCols;
        public String origin;
    }
}

