/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Joiner;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/publicapi/admin/global-tag-categories"})
public class PublicAPIGlobalTagsController
extends PublicAPIControllerBase {
    static final List<ITaggingService.TaggableType> APPLIES_TO_VALUES = PublicAPIGlobalTagsController.getAppliesToValues();
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private ProjectsService projectsService;

    @AuditedCall(value={"msgType", "publicapi-global-tag-categories-list"})
    @RequestMapping(value={""}, method={RequestMethod.GET})
    public void listGlobalTagCategories(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        ReadContext context = new ReadContext(req);
        PublicAPIGlobalTagsController.writeJSON((HttpServletResponse)resp, (Object)context.globalTagsCategories);
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-category-get", "categoryName", "${categoryName}"})
    @RequestMapping(value={"/{categoryName}"}, method={RequestMethod.GET})
    public void getGlobalTagCategory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName) throws Exception {
        ReadContext context = new ReadContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = context.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category with name %s does not exist", categoryName));
        }
        PublicAPIGlobalTagsController.writeJSON((HttpServletResponse)resp, (Object)category);
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-category-create"})
    @RequestMapping(value={""}, method={RequestMethod.POST})
    @ResponseBody
    public GeneralSettingsDAO.GlobalTagCategory createGlobalTagCategory(HttpServletRequest req, HttpServletResponse resp, @RequestBody GlobalTagCategoryDTO dto) throws Exception {
        ReadWriteContext rwContext;
        String categoryName = dto.name;
        this.require(StringUtils.isNotBlank((String)categoryName), "Required field 'name' is missing.");
        if (dto.globalTags != null) {
            PublicAPIGlobalTagsController.validateTagList(dto.globalTags);
        }
        if ((rwContext = new ReadWriteContext(req)).getCategoryByName(categoryName) != null) {
            throw ErrorContext.iaef((String)"Global tag category %s already exists", (Object)categoryName, (Object[])new Object[0]);
        }
        GeneralSettingsDAO.GlobalTagCategory category = new GeneralSettingsDAO.GlobalTagCategory();
        category.name = categoryName;
        category.globalTags = dto.globalTags == null ? new ArrayList() : dto.globalTags;
        category.appliesTo = PublicAPIGlobalTagsController.validateAppliesTo(dto.appliesTo);
        PublicAPIGlobalTagsController.generateMissingColors(category.globalTags);
        rwContext.globalTagsCategories.add(category);
        rwContext.save("Created global tag category: " + categoryName);
        return category;
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-category-edit", "categoryName", "${categoryName}"})
    @RequestMapping(value={"/{categoryName}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateGlobalTagCategory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @RequestBody GlobalTagCategoryDTO dto) throws Exception {
        ReadWriteContext rwContext = new ReadWriteContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = rwContext.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category with name %s does not exist", categoryName));
        }
        String newName = dto.name;
        if (StringUtils.isNotBlank((String)newName) && !newName.equals(categoryName)) {
            if (rwContext.getCategoryByName(newName) != null) {
                throw ErrorContext.iaef((String)"Cannot rename global tag category %s to %s, a category with this name already exist", (Object)categoryName, (Object[])new Object[]{newName});
            }
            category.name = newName;
            Map<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = PublicAPIGlobalTagsController.buildTagsToUpdateFromCategoryChange(category.globalTags, categoryName, newName, false);
            this.updateGlobalTagsForProjects(rwContext.authCtx, globalTagsToUpdate);
        }
        if (dto.appliesTo != null) {
            category.appliesTo = PublicAPIGlobalTagsController.validateAppliesTo(dto.appliesTo);
        }
        if (dto.globalTags != null) {
            category.globalTags = dto.globalTags;
        }
        rwContext.save("Updated global category");
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-category-delete", "categoryName", "${categoryName}"})
    @RequestMapping(value={"/{categoryName}"}, method={RequestMethod.DELETE})
    public void deleteGlobalTagCategory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @RequestParam(defaultValue="keep") String deletionMode, @RequestParam(defaultValue="") String reassignTo) throws Exception {
        DeletionMode mode = this.validateDeletionMode(deletionMode, reassignTo);
        if (mode == DeletionMode.REASSIGN && Objects.equals(categoryName, reassignTo)) {
            throw new IllegalArgumentException("Invalid reassignTo value: it cannot be the same than the category to delete.");
        }
        ReadWriteContext rwContext = new ReadWriteContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = rwContext.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category with name %s does not exist", categoryName));
        }
        GeneralSettingsDAO.GlobalTagCategory reassignToCategory = rwContext.getCategoryByName(reassignTo);
        HashSet<String> reassignCategoryExistingTags = new HashSet<String>();
        if (mode == DeletionMode.REASSIGN) {
            if (reassignToCategory == null) {
                throw new NotFoundException(String.format("Global tag category with name %s does not exist", reassignTo));
            }
            for (GeneralSettingsDAO.GlobalTag globalTag : reassignToCategory.globalTags) {
                reassignCategoryExistingTags.add(globalTag.name);
            }
        }
        if (mode == DeletionMode.REMOVE || mode == DeletionMode.REASSIGN) {
            if (mode == DeletionMode.REASSIGN) {
                category.name = reassignToCategory.name;
            }
            Map<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = PublicAPIGlobalTagsController.buildTagsToUpdateFromCategoryChange(category.globalTags, categoryName, category.name, mode == DeletionMode.REMOVE);
            this.updateGlobalTagsForProjects(rwContext.authCtx, globalTagsToUpdate);
            if (mode == DeletionMode.REASSIGN) {
                for (GeneralSettingsDAO.GlobalTag globalTag : category.globalTags) {
                    if (reassignCategoryExistingTags.contains(globalTag.name)) continue;
                    reassignToCategory.globalTags.add(globalTag);
                }
            }
        }
        rwContext.globalTagsCategories.remove(category);
        rwContext.save("Deleted global tag category " + categoryName);
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-category-get", "categoryName", "${categoryName}", "tagName", "${tagName}"})
    @RequestMapping(value={"/{categoryName}/tags/{tagName}"}, method={RequestMethod.GET})
    public void getGlobalTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @PathVariable String tagName) throws Exception {
        ReadContext context = new ReadContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = context.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category %s does not exist", categoryName));
        }
        GeneralSettingsDAO.GlobalTag tag = PublicAPIGlobalTagsController.getGlobalTagByName(category, tagName);
        if (tag == null) {
            throw new NotFoundException(String.format("Global tag with category %s and name %s does not exist", categoryName, tagName));
        }
        PublicAPIGlobalTagsController.writeJSON((HttpServletResponse)resp, (Object)tag);
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-create", "categoryName", "${categoryName}"})
    @RequestMapping(value={"/{categoryName}/tags"}, method={RequestMethod.POST})
    @ResponseBody
    public GeneralSettingsDAO.GlobalTag createGlobalTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @RequestBody GeneralSettingsDAO.GlobalTag newGlobalTag) throws Exception {
        ReadWriteContext rwContext;
        GeneralSettingsDAO.GlobalTagCategory category;
        this.require(StringUtils.isNotBlank((String)newGlobalTag.name), "Required field 'name' is missing.");
        if (StringUtils.isBlank((String)newGlobalTag.color)) {
            newGlobalTag.color = PublicAPIGlobalTagsController.generateGlobalTagColor();
        }
        if ((category = (rwContext = new ReadWriteContext(req)).getCategoryByName(categoryName)) == null) {
            throw new NotFoundException(String.format("Global tag category %s does not exist", categoryName));
        }
        GeneralSettingsDAO.GlobalTag globalTag = PublicAPIGlobalTagsController.getGlobalTagByName(category, newGlobalTag.name);
        if (globalTag != null) {
            throw ErrorContext.iaef((String)"Global tag %s already exists in category %s", (Object)newGlobalTag.name, (Object[])new Object[]{categoryName});
        }
        category.globalTags.add(newGlobalTag);
        rwContext.save(String.format("Created global tag %s:%s", categoryName, newGlobalTag.name));
        return newGlobalTag;
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-edit", "categoryName", "${categoryName}", "tagName", "${tagName}"})
    @RequestMapping(value={"/{categoryName}/tags/{tagName}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateGlobalTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @PathVariable String tagName, @RequestBody GeneralSettingsDAO.GlobalTag globalTagUpdate) throws Exception {
        ReadWriteContext rwContext = new ReadWriteContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = rwContext.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category %s does not exist", categoryName));
        }
        GeneralSettingsDAO.GlobalTag tag = PublicAPIGlobalTagsController.getGlobalTagByName(category, tagName);
        if (tag == null) {
            throw new NotFoundException(String.format("Global tag %s does not exist in category %s", tagName, categoryName));
        }
        GeneralSettingsDAO.GlobalTag renameTag = PublicAPIGlobalTagsController.getGlobalTagByName(category, globalTagUpdate.name);
        if (renameTag != null && !Objects.equals(renameTag.name, tagName)) {
            throw ErrorContext.iaef((String)"Cannot rename global tag %s in category %s to %s, a tag with this name already exist in the category", (Object)tagName, (Object[])new Object[]{categoryName, globalTagUpdate.name});
        }
        Map<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = PublicAPIGlobalTagsController.buildTagsToUpdateFromTagChange(categoryName, tag, globalTagUpdate, false);
        tag.name = globalTagUpdate.name;
        tag.color = globalTagUpdate.color;
        if (!Objects.equals(globalTagUpdate.name, tagName)) {
            this.updateGlobalTagsForProjects(rwContext.authCtx, globalTagsToUpdate);
        }
        rwContext.save(String.format("Updated global tag %s:%s", categoryName, tagName));
    }

    @AuditedCall(value={"msgType", "publicapi-global-tag-delete", "categoryName", "${categoryName}", "tagName", "${tagName}"})
    @RequestMapping(value={"/{categoryName}/tags/{tagName}"}, method={RequestMethod.DELETE})
    public void deleteGlobalTag(HttpServletRequest req, HttpServletResponse resp, @PathVariable String categoryName, @PathVariable String tagName, @RequestParam(defaultValue="keep") String deletionMode, @RequestParam(defaultValue="") String reassignTo) throws Exception {
        DeletionMode mode = this.validateDeletionMode(deletionMode, reassignTo);
        if (mode == DeletionMode.REASSIGN && Objects.equals(tagName, reassignTo)) {
            throw new IllegalArgumentException("Invalid reassignTo value: it cannot be the same than the tag to delete.");
        }
        ReadWriteContext context = new ReadWriteContext(req);
        GeneralSettingsDAO.GlobalTagCategory category = context.getCategoryByName(categoryName);
        if (category == null) {
            throw new NotFoundException(String.format("Global tag category with name %s does not exist", categoryName));
        }
        GeneralSettingsDAO.GlobalTag tag = PublicAPIGlobalTagsController.getGlobalTagByName(category, tagName);
        if (tag == null) {
            throw new NotFoundException(String.format("Global tag with name %s in category %s does not exist", tagName, categoryName));
        }
        GeneralSettingsDAO.GlobalTag reassignToTag = PublicAPIGlobalTagsController.getGlobalTagByName(category, reassignTo);
        if (mode == DeletionMode.REASSIGN && reassignToTag == null) {
            throw new NotFoundException(String.format("Cannot reassign tag %s to %s, tag does not exist in category %s", tagName, reassignTo, categoryName));
        }
        if (mode == DeletionMode.REMOVE || mode == DeletionMode.REASSIGN) {
            String newTagName = mode == DeletionMode.REASSIGN ? reassignToTag.name : tag.name;
            GeneralSettingsDAO.GlobalTag globalTagUpdate = new GeneralSettingsDAO.GlobalTag();
            globalTagUpdate.name = newTagName;
            globalTagUpdate.color = tag.color;
            Map<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = PublicAPIGlobalTagsController.buildTagsToUpdateFromTagChange(categoryName, tag, globalTagUpdate, mode == DeletionMode.REMOVE);
            this.updateGlobalTagsForProjects(context.authCtx, globalTagsToUpdate);
        }
        category.globalTags.remove(tag);
        context.save(String.format("Deleted global tag %s:%s", categoryName, tagName));
    }

    private static GeneralSettingsDAO.GlobalTag getGlobalTagByName(GeneralSettingsDAO.GlobalTagCategory globalTagCategory, String tagName) {
        for (GeneralSettingsDAO.GlobalTag globalTag : globalTagCategory.globalTags) {
            if (!Objects.equals(globalTag.name, tagName)) continue;
            return globalTag;
        }
        return null;
    }

    private static Map<String, TaggingService.GlobalTagUpdate> buildTagsToUpdateFromCategoryChange(List<GeneralSettingsDAO.GlobalTag> globalTagsList, String categoryName, String newCategoryName, boolean removeUsage) {
        HashMap<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = new HashMap<String, TaggingService.GlobalTagUpdate>();
        for (GeneralSettingsDAO.GlobalTag globalTag : globalTagsList) {
            TaggingService.GlobalTagUpdate globalTagUpdate = new TaggingService.GlobalTagUpdate(newCategoryName + ":" + globalTag.name, globalTag.color, removeUsage);
            globalTagsToUpdate.put(categoryName + ":" + globalTag.name, globalTagUpdate);
        }
        return globalTagsToUpdate;
    }

    private static Map<String, TaggingService.GlobalTagUpdate> buildTagsToUpdateFromTagChange(String categoryName, GeneralSettingsDAO.GlobalTag originalGlobalTag, GeneralSettingsDAO.GlobalTag tagUpdate, boolean removeUsage) {
        HashMap<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate = new HashMap<String, TaggingService.GlobalTagUpdate>();
        if (tagUpdate.color == null) {
            tagUpdate.color = originalGlobalTag.color;
        }
        if (tagUpdate.name == null) {
            tagUpdate.name = originalGlobalTag.name;
        }
        TaggingService.GlobalTagUpdate globalTagUpdate = new TaggingService.GlobalTagUpdate(categoryName + ":" + tagUpdate.name, tagUpdate.color, removeUsage);
        globalTagsToUpdate.put(categoryName + ":" + originalGlobalTag.name, globalTagUpdate);
        return globalTagsToUpdate;
    }

    private void updateGlobalTagsForProjects(AuthCtx authCtx, Map<String, TaggingService.GlobalTagUpdate> globalTagsToUpdate) throws Exception {
        List pKeys;
        try (Transaction ignored = this.transactionService.beginRead();){
            pKeys = this.projectsService.listProjectKeys();
        }
        for (String projectKey : pKeys) {
            RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                this.taggingService.updateGlobalTags(projectKey, globalTagsToUpdate, authCtx);
                t.commit("Updated global tags for project: " + projectKey);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    private DeletionMode validateDeletionMode(String deletionMode, String reassignTo) {
        DeletionMode mode;
        try {
            mode = DeletionMode.valueOf(deletionMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw ErrorContext.iaef((String)"Invalid deletion mode: %s - Expected 'keep', 'remove' or 'reassign'", (Object)deletionMode, (Object[])new Object[0]);
        }
        this.require(mode != DeletionMode.REASSIGN || StringUtils.isNotBlank((String)reassignTo), "Required parameter 'reassignTo' is missing.");
        return mode;
    }

    private static List<ITaggingService.TaggableType> validateAppliesTo(List<String> appliesTo) {
        if (appliesTo == null) {
            return new ArrayList<ITaggingService.TaggableType>(APPLIES_TO_VALUES);
        }
        HashSet<ITaggingService.TaggableType> result = new HashSet<ITaggingService.TaggableType>();
        for (String str : appliesTo) {
            ITaggingService.TaggableType taggableType = PublicAPIGlobalTagsController.parseTaggableType(str);
            if (taggableType == null) {
                throw ErrorContext.iaef((String)"Invalid appliesTo value: %s. Valid values are: %s", (Object)str, (Object[])new Object[]{Joiner.on((String)", ").join(APPLIES_TO_VALUES)});
            }
            result.add(taggableType);
        }
        return new ArrayList<ITaggingService.TaggableType>(result);
    }

    private static void validateTagList(List<GeneralSettingsDAO.GlobalTag> globalTags) {
        for (GeneralSettingsDAO.GlobalTag globalTag : globalTags) {
            if (!StringUtils.isBlank((String)globalTag.name)) continue;
            throw ErrorContext.iae((String)"globalTags contains empty or invalid tag names");
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (GeneralSettingsDAO.GlobalTag globalTag : globalTags) {
            if (usedNames.contains(globalTag.name)) {
                throw ErrorContext.iaef((String)"globalTags contains duplicate tag names: %s", (Object)globalTag.name, (Object[])new Object[0]);
            }
            usedNames.add(globalTag.name);
        }
    }

    private static void generateMissingColors(List<GeneralSettingsDAO.GlobalTag> tags) {
        Random rnd = new Random();
        for (GeneralSettingsDAO.GlobalTag tag : tags) {
            if (!StringUtils.isBlank((String)tag.color)) continue;
            tag.color = PublicAPIGlobalTagsController.generateGlobalTagColor(rnd);
        }
    }

    private static String generateGlobalTagColor() {
        return PublicAPIGlobalTagsController.generateGlobalTagColor(new Random());
    }

    private static String generateGlobalTagColor(Random rnd) {
        int randomVal = rnd.nextInt(0x1000000);
        return String.format("#%06x", randomVal);
    }

    private static ITaggingService.TaggableType parseTaggableType(String str) {
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        try {
            ITaggingService.TaggableType appliesToType = ITaggingService.TaggableType.valueOf((String)str.toUpperCase(Locale.ROOT));
            if (appliesToType.isFakeType()) {
                return null;
            }
            return appliesToType;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static List<ITaggingService.TaggableType> getAppliesToValues() {
        ArrayList<ITaggingService.TaggableType> result = new ArrayList<ITaggingService.TaggableType>();
        for (ITaggingService.TaggableType taggableType : ITaggingService.TaggableType.values()) {
            if (taggableType.isFakeType()) continue;
            result.add(taggableType);
        }
        return Collections.unmodifiableList(result);
    }

    private class ReadContext
    extends OperationContext {
        public ReadContext(HttpServletRequest req) throws DKUSecurityException, IOException {
            super(req, true);
        }
    }

    public static class GlobalTagCategoryDTO {
        public String name;
        public List<GeneralSettingsDAO.GlobalTag> globalTags;
        public List<String> appliesTo;
    }

    private class ReadWriteContext
    extends OperationContext {
        public ReadWriteContext(HttpServletRequest req) throws DKUSecurityException, IOException {
            super(req, false);
        }

        public void save(String commitMessage) throws IOException, DKUSecurityException {
            try (RWTransaction t = PublicAPIGlobalTagsController.this.transactionService.beginWriteForAPI(this.req);){
                PublicAPIGlobalTagsController.this.generalSettingsDAO.save(this.generalSettings);
                t.commit(commitMessage);
            }
        }
    }

    public static enum DeletionMode {
        KEEP,
        REMOVE,
        REASSIGN;

    }

    private abstract class OperationContext {
        public final HttpServletRequest req;
        public final AuthCtx authCtx;
        public final List<GeneralSettingsDAO.GlobalTagCategory> globalTagsCategories;
        protected final GeneralSettingsDAO.GeneralSettings generalSettings;

        protected OperationContext(HttpServletRequest req, boolean readOnly) throws DKUSecurityException, IOException {
            this.req = req;
            try (Transaction ignored = PublicAPIGlobalTagsController.this.transactionService.beginRead();){
                this.authCtx = PublicAPIGlobalTagsController.this.authService.getTicketOrKey(req);
                PublicAPIGlobalTagsController.this.permissionsService.checkAdmin(this.authCtx);
                this.generalSettings = readOnly ? PublicAPIGlobalTagsController.this.generalSettingsDAO.getUnsafe() : PublicAPIGlobalTagsController.this.generalSettingsDAO.read();
            }
            this.globalTagsCategories = this.generalSettings.globalTagsCategories;
        }

        public GeneralSettingsDAO.GlobalTagCategory getCategoryByName(String categoryName) {
            for (GeneralSettingsDAO.GlobalTagCategory gtc : this.generalSettings.globalTagsCategories) {
                if (!Objects.equals(gtc.name, categoryName)) continue;
                return gtc;
            }
            return null;
        }
    }
}

