/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom.prep;

import com.databricks.internal.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.databricks.internal.jts.algorithm.locate.PointOnGeometryLocator;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.Polygonal;
import com.databricks.internal.jts.geom.prep.BasicPreparedGeometry;
import com.databricks.internal.jts.geom.prep.PreparedPolygonContains;
import com.databricks.internal.jts.geom.prep.PreparedPolygonContainsProperly;
import com.databricks.internal.jts.geom.prep.PreparedPolygonCovers;
import com.databricks.internal.jts.geom.prep.PreparedPolygonIntersects;
import com.databricks.internal.jts.noding.FastSegmentSetIntersectionFinder;
import com.databricks.internal.jts.noding.SegmentStringUtil;
import com.databricks.internal.jts.operation.predicate.RectangleContains;
import com.databricks.internal.jts.operation.predicate.RectangleIntersects;

public class PreparedPolygon
extends BasicPreparedGeometry {
    private final boolean isRectangle = this.getGeometry().isRectangle();
    private FastSegmentSetIntersectionFinder segIntFinder = null;
    private PointOnGeometryLocator pia = null;

    public PreparedPolygon(Polygonal poly) {
        super((Geometry)((Object)poly));
    }

    public synchronized FastSegmentSetIntersectionFinder getIntersectionFinder() {
        if (this.segIntFinder == null) {
            this.segIntFinder = new FastSegmentSetIntersectionFinder(SegmentStringUtil.extractSegmentStrings(this.getGeometry()));
        }
        return this.segIntFinder;
    }

    public synchronized PointOnGeometryLocator getPointLocator() {
        if (this.pia == null) {
            this.pia = new IndexedPointInAreaLocator(this.getGeometry());
        }
        return this.pia;
    }

    @Override
    public boolean intersects(Geometry g2) {
        if (!this.envelopesIntersect(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleIntersects.intersects((Polygon)this.getGeometry(), g2);
        }
        return PreparedPolygonIntersects.intersects(this, g2);
    }

    @Override
    public boolean contains(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleContains.contains((Polygon)this.getGeometry(), g2);
        }
        return PreparedPolygonContains.contains(this, g2);
    }

    @Override
    public boolean containsProperly(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        return PreparedPolygonContainsProperly.containsProperly(this, g2);
    }

    @Override
    public boolean covers(Geometry g2) {
        if (!this.envelopeCovers(g2)) {
            return false;
        }
        if (this.isRectangle) {
            return true;
        }
        return PreparedPolygonCovers.covers(this, g2);
    }
}

