/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.relateng;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.operation.relateng.NodeSection;
import com.databricks.internal.jts.operation.relateng.PolygonNodeConverter;
import com.databricks.internal.jts.operation.relateng.RelateNode;
import java.util.ArrayList;
import java.util.List;

class NodeSections {
    private Coordinate nodePt;
    private List<NodeSection> sections = new ArrayList<NodeSection>();

    public NodeSections(Coordinate pt) {
        this.nodePt = pt;
    }

    public Coordinate getCoordinate() {
        return this.nodePt;
    }

    public void addNodeSection(NodeSection e) {
        this.sections.add(e);
    }

    public boolean hasInteractionAB() {
        boolean isA = false;
        boolean isB = false;
        for (NodeSection ns : this.sections) {
            if (ns.isA()) {
                isA = true;
            } else {
                isB = true;
            }
            if (!isA || !isB) continue;
            return true;
        }
        return false;
    }

    public Geometry getPolygonal(boolean isA) {
        for (NodeSection ns : this.sections) {
            Geometry poly;
            if (ns.isA() != isA || (poly = ns.getPolygonal()) == null) continue;
            return poly;
        }
        return null;
    }

    public RelateNode createNode() {
        this.prepareSections();
        RelateNode node = new RelateNode(this.nodePt);
        int i = 0;
        while (i < this.sections.size()) {
            NodeSection ns = this.sections.get(i);
            if (ns.isArea() && NodeSections.hasMultiplePolygonSections(this.sections, i)) {
                List<NodeSection> polySections = NodeSections.collectPolygonSections(this.sections, i);
                List<NodeSection> nsConvert = PolygonNodeConverter.convert(polySections);
                node.addEdges(nsConvert);
                i += polySections.size();
                continue;
            }
            node.addEdges(ns);
            ++i;
        }
        return node;
    }

    private void prepareSections() {
        this.sections.sort(null);
    }

    private static boolean hasMultiplePolygonSections(List<NodeSection> sections, int i) {
        if (i >= sections.size() - 1) {
            return false;
        }
        NodeSection ns = sections.get(i);
        NodeSection nsNext = sections.get(i + 1);
        return ns.isSamePolygon(nsNext);
    }

    private static List<NodeSection> collectPolygonSections(List<NodeSection> sections, int i) {
        ArrayList<NodeSection> polySections = new ArrayList<NodeSection>();
        NodeSection polySection = sections.get(i);
        while (i < sections.size() && polySection.isSamePolygon(sections.get(i))) {
            polySections.add(sections.get(i));
            ++i;
        }
        return polySections;
    }
}

