/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.union;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.Polygon;
import com.databricks.internal.jts.geom.Polygonal;
import com.databricks.internal.jts.geom.TopologyException;
import com.databricks.internal.jts.geom.util.PolygonExtracter;
import com.databricks.internal.jts.index.strtree.STRtree;
import com.databricks.internal.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.databricks.internal.jts.operation.overlayng.OverlayNGRobust;
import com.databricks.internal.jts.operation.union.UnionStrategy;
import com.databricks.internal.jts.util.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CascadedPolygonUnion {
    static final UnionStrategy CLASSIC_UNION = new UnionStrategy(){

        @Override
        public Geometry union(Geometry g0, Geometry g1) {
            try {
                return SnapIfNeededOverlayOp.union(g0, g1);
            }
            catch (TopologyException ex) {
                return OverlayNGRobust.overlay(g0, g1, 2);
            }
        }

        @Override
        public boolean isFloatingPrecision() {
            return true;
        }
    };
    private Collection inputPolys;
    private GeometryFactory geomFactory = null;
    private UnionStrategy unionFun;
    private int countRemainder = 0;
    private int countInput = 0;
    private static final int STRTREE_NODE_CAPACITY = 4;

    public static Geometry union(Collection polys) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys);
        return op.union();
    }

    public static Geometry union(Collection polys, UnionStrategy unionFun) {
        CascadedPolygonUnion op = new CascadedPolygonUnion(polys, unionFun);
        return op.union();
    }

    public CascadedPolygonUnion(Collection polys) {
        this(polys, CLASSIC_UNION);
    }

    public CascadedPolygonUnion(Collection polys, UnionStrategy unionFun) {
        this.inputPolys = polys;
        this.unionFun = unionFun;
        if (this.inputPolys == null) {
            this.inputPolys = new ArrayList();
        }
        this.countRemainder = this.countInput = this.inputPolys.size();
    }

    public Geometry union() {
        if (this.inputPolys == null) {
            throw new IllegalStateException("union() method cannot be called twice");
        }
        if (this.inputPolys.isEmpty()) {
            return null;
        }
        this.geomFactory = ((Geometry)this.inputPolys.iterator().next()).getFactory();
        STRtree index = new STRtree(4);
        for (Geometry item : this.inputPolys) {
            index.insert(item.getEnvelopeInternal(), (Object)item);
        }
        this.inputPolys = null;
        List itemTree = index.itemsTree();
        Geometry unionAll = this.unionTree(itemTree);
        return unionAll;
    }

    private Geometry unionTree(List geomTree) {
        List geoms = this.reduceToGeometries(geomTree);
        Geometry union = this.binaryUnion(geoms);
        return union;
    }

    private Geometry binaryUnion(List geoms) {
        return this.binaryUnion(geoms, 0, geoms.size());
    }

    private Geometry binaryUnion(List geoms, int start, int end) {
        if (end - start <= 1) {
            Geometry g0 = CascadedPolygonUnion.getGeometry(geoms, start);
            return this.unionSafe(g0, null);
        }
        if (end - start == 2) {
            return this.unionSafe(CascadedPolygonUnion.getGeometry(geoms, start), CascadedPolygonUnion.getGeometry(geoms, start + 1));
        }
        int mid = (end + start) / 2;
        Geometry g0 = this.binaryUnion(geoms, start, mid);
        Geometry g1 = this.binaryUnion(geoms, mid, end);
        return this.unionSafe(g0, g1);
    }

    private static Geometry getGeometry(List list, int index) {
        if (index >= list.size()) {
            return null;
        }
        return (Geometry)list.get(index);
    }

    private List reduceToGeometries(List geomTree) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object o : geomTree) {
            Geometry geom = null;
            if (o instanceof List) {
                geom = this.unionTree((List)o);
            } else if (o instanceof Geometry) {
                geom = (Geometry)o;
            }
            geoms.add(geom);
        }
        return geoms;
    }

    private Geometry unionSafe(Geometry g0, Geometry g1) {
        if (g0 == null && g1 == null) {
            return null;
        }
        if (g0 == null) {
            return g1.copy();
        }
        if (g1 == null) {
            return g0.copy();
        }
        --this.countRemainder;
        if (Debug.isDebugging()) {
            Debug.println("Remainder: " + this.countRemainder + " out of " + this.countInput);
            Debug.print("Union: A: " + g0.getNumPoints() + " / B: " + g1.getNumPoints() + "  ---  ");
        }
        Geometry union = this.unionActual(g0, g1);
        if (Debug.isDebugging()) {
            Debug.println(" Result: " + union.getNumPoints());
        }
        return union;
    }

    private Geometry unionActual(Geometry g0, Geometry g1) {
        Geometry union = this.unionFun.union(g0, g1);
        Geometry unionPoly = CascadedPolygonUnion.restrictToPolygons(union);
        return unionPoly;
    }

    private static Geometry restrictToPolygons(Geometry g2) {
        if (g2 instanceof Polygonal) {
            return g2;
        }
        List polygons = PolygonExtracter.getPolygons(g2);
        if (polygons.size() == 1) {
            return (Polygon)polygons.get(0);
        }
        return g2.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray(polygons));
    }
}

