/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.CreateInstancePool;
import com.databricks.internal.sdk.service.compute.CreateInstancePoolResponse;
import com.databricks.internal.sdk.service.compute.DeleteInstancePool;
import com.databricks.internal.sdk.service.compute.EditInstancePool;
import com.databricks.internal.sdk.service.compute.GetInstancePool;
import com.databricks.internal.sdk.service.compute.GetInstancePoolPermissionLevelsRequest;
import com.databricks.internal.sdk.service.compute.GetInstancePoolPermissionLevelsResponse;
import com.databricks.internal.sdk.service.compute.GetInstancePoolPermissionsRequest;
import com.databricks.internal.sdk.service.compute.GetInstancePoolRequest;
import com.databricks.internal.sdk.service.compute.InstancePoolAndStats;
import com.databricks.internal.sdk.service.compute.InstancePoolPermissions;
import com.databricks.internal.sdk.service.compute.InstancePoolPermissionsRequest;
import com.databricks.internal.sdk.service.compute.InstancePoolsImpl;
import com.databricks.internal.sdk.service.compute.InstancePoolsService;
import com.databricks.internal.sdk.service.compute.ListInstancePools;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class InstancePoolsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(InstancePoolsAPI.class);
    private final InstancePoolsService impl;

    public InstancePoolsAPI(ApiClient apiClient) {
        this.impl = new InstancePoolsImpl(apiClient);
    }

    public InstancePoolsAPI(InstancePoolsService mock) {
        this.impl = mock;
    }

    public CreateInstancePoolResponse create(CreateInstancePool request) {
        return this.impl.create(request);
    }

    public void delete(String instancePoolId) {
        this.delete(new DeleteInstancePool().setInstancePoolId(instancePoolId));
    }

    public void delete(DeleteInstancePool request) {
        this.impl.delete(request);
    }

    public void edit(EditInstancePool request) {
        this.impl.edit(request);
    }

    public GetInstancePool get(String instancePoolId) {
        return this.get(new GetInstancePoolRequest().setInstancePoolId(instancePoolId));
    }

    public GetInstancePool get(GetInstancePoolRequest request) {
        return this.impl.get(request);
    }

    public GetInstancePoolPermissionLevelsResponse getPermissionLevels(String instancePoolId) {
        return this.getPermissionLevels(new GetInstancePoolPermissionLevelsRequest().setInstancePoolId(instancePoolId));
    }

    public GetInstancePoolPermissionLevelsResponse getPermissionLevels(GetInstancePoolPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public InstancePoolPermissions getPermissions(String instancePoolId) {
        return this.getPermissions(new GetInstancePoolPermissionsRequest().setInstancePoolId(instancePoolId));
    }

    public InstancePoolPermissions getPermissions(GetInstancePoolPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<InstancePoolAndStats> list() {
        return new Paginator(null, v -> this.impl.list(), ListInstancePools::getInstancePools, response -> null);
    }

    public InstancePoolPermissions setPermissions(InstancePoolPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public InstancePoolPermissions updatePermissions(InstancePoolPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public InstancePoolsService impl() {
        return this.impl;
    }
}

