/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.iam.DeleteGroupRequest;
import com.databricks.internal.sdk.service.iam.GetGroupRequest;
import com.databricks.internal.sdk.service.iam.Group;
import com.databricks.internal.sdk.service.iam.GroupsImpl;
import com.databricks.internal.sdk.service.iam.GroupsService;
import com.databricks.internal.sdk.service.iam.ListGroupsRequest;
import com.databricks.internal.sdk.service.iam.ListGroupsResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class GroupsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsAPI.class);
    private final GroupsService impl;

    public GroupsAPI(ApiClient apiClient) {
        this.impl = new GroupsImpl(apiClient);
    }

    public GroupsAPI(GroupsService mock) {
        this.impl = mock;
    }

    public Group create(Group request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteGroupRequest().setId(id));
    }

    public void delete(DeleteGroupRequest request) {
        this.impl.delete(request);
    }

    public Group get(String id) {
        return this.get(new GetGroupRequest().setId(id));
    }

    public Group get(GetGroupRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Group> list(ListGroupsRequest request) {
        request.setStartIndex(1L);
        if (request.getCount() == null) {
            request.setCount(10000L);
        }
        return new Paginator<ListGroupsRequest, ListGroupsResponse, Group>(request, this.impl::list, ListGroupsResponse::getResources, response -> {
            Long offset = request.getStartIndex();
            if (offset == null) {
                offset = 0L;
            }
            offset = offset + (long)response.getResources().size();
            return request.setStartIndex(offset);
        }).withDedupe(Group::getId);
    }

    public void patch(PartialUpdate request) {
        this.impl.patch(request);
    }

    public void update(Group request) {
        this.impl.update(request);
    }

    public GroupsService impl() {
        return this.impl;
    }
}

