/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.thrift;

import com.databricks.internal.apache.http.HttpException;
import com.databricks.internal.apache.thrift.TBase;
import com.databricks.internal.apache.thrift.TException;
import com.databricks.internal.apache.thrift.TFieldIdEnum;
import com.databricks.internal.apache.thrift.protocol.TBinaryProtocol;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.service.sql.StatementState;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.DatabricksClientConfiguratorManager;
import com.databricks.jdbc.common.EnvironmentVariables;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.ProtocolFeatureUtil;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.common.TimeoutHandler;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.dbclient.impl.thrift.DatabricksHttpTTransport;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.exception.DatabricksTimeoutException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TCLIService;
import com.databricks.jdbc.model.client.thrift.generated.TCancelOperationReq;
import com.databricks.jdbc.model.client.thrift.generated.TCancelOperationResp;
import com.databricks.jdbc.model.client.thrift.generated.TCloseOperationReq;
import com.databricks.jdbc.model.client.thrift.generated.TCloseOperationResp;
import com.databricks.jdbc.model.client.thrift.generated.TCloseSessionReq;
import com.databricks.jdbc.model.client.thrift.generated.TExecuteStatementReq;
import com.databricks.jdbc.model.client.thrift.generated.TExecuteStatementResp;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsReq;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetCatalogsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetCatalogsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetColumnsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetColumnsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetCrossReferenceReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetCrossReferenceResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetFunctionsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetFunctionsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetOperationStatusReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetOperationStatusResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetPrimaryKeysReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetPrimaryKeysResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetSchemasReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetSchemasResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetTableTypesReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetTableTypesResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetTablesReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetTablesResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetTypeInfoReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetTypeInfoResp;
import com.databricks.jdbc.model.client.thrift.generated.TOpenSessionReq;
import com.databricks.jdbc.model.client.thrift.generated.TOperationHandle;
import com.databricks.jdbc.model.client.thrift.generated.TOperationState;
import com.databricks.jdbc.model.client.thrift.generated.TProtocolVersion;
import com.databricks.jdbc.model.client.thrift.generated.TSparkDirectResults;
import com.databricks.jdbc.model.client.thrift.generated.TSparkGetDirectResults;
import com.databricks.jdbc.model.client.thrift.generated.TStatus;
import com.databricks.jdbc.model.client.thrift.generated.TStatusCode;
import com.databricks.jdbc.model.core.StatementStatus;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.latency.TelemetryCollector;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

final class DatabricksThriftAccessor {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksThriftAccessor.class);
    private static final TSparkGetDirectResults DEFAULT_DIRECT_RESULTS = new TSparkGetDirectResults().setMaxRows(2000000L).setMaxBytes(404857600L);
    private static final short directResultsFieldId = TExecuteStatementResp._Fields.DIRECT_RESULTS.getThriftFieldId();
    private static final short operationHandleFieldId = TExecuteStatementResp._Fields.OPERATION_HANDLE.getThriftFieldId();
    private static final short statusFieldId = TExecuteStatementResp._Fields.STATUS.getThriftFieldId();
    private DatabricksConfig databricksConfig;
    private final boolean enableDirectResults;
    private final int asyncPollIntervalMillis;
    private final int maxRowsPerBlock;
    private final String connectionUuid;
    private final String endpointUrl;
    private final IDatabricksConnectionContext connectionContext;
    private TProtocolVersion serverProtocolVersion = EnvironmentVariables.JDBC_THRIFT_VERSION;
    private ThreadLocal<TCLIService.Client> FAKE_SHARED_CLIENT;

    DatabricksThriftAccessor(IDatabricksConnectionContext connectionContext) throws DatabricksParsingException, DatabricksValidationException {
        this.enableDirectResults = connectionContext.getDirectResultMode();
        this.databricksConfig = DatabricksClientConfiguratorManager.getInstance().getConfigurator(connectionContext).getDatabricksConfig();
        this.endpointUrl = connectionContext.getEndpointURL();
        this.asyncPollIntervalMillis = connectionContext.getAsyncExecPollInterval();
        this.maxRowsPerBlock = connectionContext.getRowsFetchedPerBlock();
        this.connectionUuid = connectionContext.getConnectionUuid();
        this.connectionContext = connectionContext;
        if (DriverUtil.isRunningAgainstFake()) {
            TCLIService.Client client = this.newThriftClient();
            this.FAKE_SHARED_CLIENT = ThreadLocal.withInitial(() -> client);
        }
    }

    TBase getThriftResponse(TBase request) throws DatabricksSQLException {
        LOGGER.debug("Fetching thrift response for request {}", request.toString());
        try {
            if (request instanceof TOpenSessionReq) {
                return this.getThriftClient().OpenSession((TOpenSessionReq)request);
            }
            if (request instanceof TCloseSessionReq) {
                return this.getThriftClient().CloseSession((TCloseSessionReq)request);
            }
            if (request instanceof TGetFunctionsReq) {
                return this.listFunctions((TGetFunctionsReq)request);
            }
            if (request instanceof TGetPrimaryKeysReq) {
                return this.listPrimaryKeys((TGetPrimaryKeysReq)request);
            }
            if (request instanceof TGetCrossReferenceReq) {
                return this.listCrossReferences((TGetCrossReferenceReq)request);
            }
            if (request instanceof TGetCatalogsReq) {
                return this.getCatalogs((TGetCatalogsReq)request);
            }
            if (request instanceof TGetTablesReq) {
                return this.getTables((TGetTablesReq)request);
            }
            if (request instanceof TGetTableTypesReq) {
                return this.getTableTypes((TGetTableTypesReq)request);
            }
            if (request instanceof TGetSchemasReq) {
                return this.listSchemas((TGetSchemasReq)request);
            }
            if (request instanceof TGetTypeInfoReq) {
                return this.getTypeInfo((TGetTypeInfoReq)request);
            }
            if (request instanceof TGetColumnsReq) {
                return this.listColumns((TGetColumnsReq)request);
            }
            String errorMessage = String.format("No implementation for fetching thrift response for Request {%s}", request);
            LOGGER.error(errorMessage);
            throw new DatabricksSQLFeatureNotSupportedException(errorMessage);
        }
        catch (TException | SQLException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof HttpException)) continue;
                throw new DatabricksHttpException(cause.getMessage(), cause, DatabricksDriverErrorCode.INVALID_STATE);
            }
            String errorMessage = String.format("Error while receiving response from Thrift server. Request {%s}, Error {%s}", request, e.getMessage());
            LOGGER.error(e, errorMessage);
            if (e instanceof SQLException) {
                throw new DatabricksSQLException(errorMessage, (Throwable)e, ((SQLException)e).getSQLState());
            }
            throw new DatabricksSQLException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    TFetchResultsResp getResultSetResp(TOperationHandle operationHandle, String context) throws DatabricksHttpException {
        return this.getResultSetResp(new TStatus().setStatusCode(TStatusCode.SUCCESS_STATUS), operationHandle, context, this.maxRowsPerBlock, false);
    }

    TCancelOperationResp cancelOperation(TCancelOperationReq req) throws DatabricksHttpException {
        try {
            return this.getThriftClient().CancelOperation(req);
        }
        catch (TException e) {
            String errorMessage = String.format("Error while canceling operation from Thrift server. Request {%s}, Error {%s}", req.toString(), e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    TCloseOperationResp closeOperation(TCloseOperationReq req) throws DatabricksHttpException {
        try {
            return this.getThriftClient().CloseOperation(req);
        }
        catch (TException e) {
            String errorMessage = String.format("Error while closing operation from Thrift server. Request {%s}, Error {%s}", req.toString(), e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    TFetchResultsResp getMoreResults(IDatabricksStatementInternal parentStatement) throws DatabricksSQLException {
        String context = String.format("Fetching more results as it has more rows %s", parentStatement.getStatementId().toSQLExecStatementId());
        return this.getResultSetResp(new TStatus().setStatusCode(TStatusCode.SUCCESS_STATUS), DatabricksThriftUtil.getOperationHandle(parentStatement.getStatementId()), context, this.maxRowsPerBlock, true);
    }

    DatabricksResultSet execute(TExecuteStatementReq request, IDatabricksStatementInternal parentStatement, IDatabricksSession session, StatementType statementType) throws SQLException {
        try {
            TFetchResultsResp resultSet;
            if (this.enableDirectResults) {
                TSparkGetDirectResults directResults = new TSparkGetDirectResults().setMaxBytes(404857600L).setMaxRows(this.maxRowsPerBlock);
                request.setGetDirectResults(directResults);
            }
            TExecuteStatementResp response = this.getThriftClient().ExecuteStatement(request);
            this.checkResponseForErrors(response);
            StatementId statementId = new StatementId(response.getOperationHandle().operationId);
            LOGGER.debug("Executed statement for statementId {} in session {}", statementId.toSQLExecStatementId(), session.getSessionId());
            DatabricksThreadContextHolder.setStatementId(statementId);
            if (parentStatement != null) {
                parentStatement.setStatementId(statementId);
            }
            String sessionDebugInfo = String.format("Session [%s] with (%s)", session.getSessionId(), session.getComputeResource());
            TGetOperationStatusResp statusResp = this.pollTillOperationFinished(response, parentStatement, session, statementId, sessionDebugInfo);
            if (this.hasResultDataInDirectResults(response)) {
                resultSet = response.getDirectResults().getResultSet();
                resultSet.setResultSetMetadata(response.getDirectResults().getResultSetMetadata());
            } else {
                long fetchStartTime = System.nanoTime();
                resultSet = this.getResultSetResp(response.getStatus(), response.getOperationHandle(), "executeStatement", this.maxRowsPerBlock, true);
                long fetchEndTime = System.nanoTime();
                long fetchLatencyNanos = fetchEndTime - fetchStartTime;
                long fetchLatencyMillis = fetchLatencyNanos / 1000000L;
                LOGGER.debug(String.format("Connection [%s] Statement [%s] Session [%s] Thrift fetch latency: %dms", this.connectionUuid, statementId, sessionDebugInfo, fetchLatencyMillis));
            }
            return new DatabricksResultSet(DatabricksThriftUtil.getStatementStatus(statusResp), statementId, resultSet, statementType, parentStatement, session);
        }
        catch (TException e) {
            String errorMessage = String.format("Error while receiving response from Thrift server. Request {%s}, Error {%s}", request, e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
    }

    private TGetOperationStatusResp pollTillOperationFinished(TExecuteStatementResp response, IDatabricksStatementInternal parentStatement, IDatabricksSession session, StatementId statementId, String sessionDebugInfo) throws SQLException, TException {
        int timeoutInSeconds = parentStatement == null ? 0 : parentStatement.getStatement().getQueryTimeout();
        TGetOperationStatusResp statusResp = null;
        if (response.isSetDirectResults()) {
            DatabricksThriftUtil.checkDirectResultsForErrorStatus(response.getDirectResults(), "executeStatement DirectResults", statementId.toSQLExecStatementId());
            statusResp = response.getDirectResults().getOperationStatus();
            this.checkOperationStatusForErrors(statusResp, StatementId.loggableStatementId(response.getOperationHandle()));
        }
        TimeoutHandler timeoutHandler = this.getTimeoutHandler(response, timeoutInSeconds, DatabricksDriverErrorCode.STATEMENT_EXECUTION_TIMEOUT);
        long pollingStartTime = System.nanoTime();
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq().setOperationHandle(response.getOperationHandle()).setGetProgressUpdate(false);
        while (this.shouldContinuePolling(statusResp)) {
            timeoutHandler.checkTimeout();
            statusResp = this.getOperationStatus(statusReq, statementId);
            this.checkOperationStatusForErrors(statusResp, statementId.toSQLExecStatementId());
            if (!this.shouldContinuePolling(statusResp)) break;
            try {
                TimeUnit.MILLISECONDS.sleep(this.asyncPollIntervalMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.cancelOperation(new TCancelOperationReq().setOperationHandle(response.getOperationHandle()));
                throw new DatabricksSQLException("Query execution interrupted", (Throwable)e, DatabricksDriverErrorCode.THREAD_INTERRUPTED_ERROR);
            }
        }
        long pollingEndTime = System.nanoTime();
        long pollingLatencyNanos = pollingEndTime - pollingStartTime;
        long pollingLatencyMillis = pollingLatencyNanos / 1000000L;
        LOGGER.debug(String.format("Connection [%s] Statement [%s] Session [%s] Thrift polling latency: %dms", this.connectionUuid, statementId, sessionDebugInfo, pollingLatencyMillis));
        return statusResp;
    }

    DatabricksResultSet executeAsync(TExecuteStatementReq request, IDatabricksStatementInternal parentStatement, IDatabricksSession session, StatementType statementType) throws SQLException {
        TExecuteStatementResp response;
        try {
            response = this.getThriftClient().ExecuteStatement(request);
            if (Arrays.asList(TStatusCode.ERROR_STATUS, TStatusCode.INVALID_HANDLE_STATUS).contains(response.status.statusCode)) {
                LOGGER.error("Received error response {} from Thrift Server for request {}", response, request.toString());
                throw new DatabricksSQLException(response.status.errorMessage, response.status.sqlState);
            }
        }
        catch (TException | DatabricksSQLException e) {
            String errorMessage = String.format("Error while receiving response from Thrift server. Request {%s}, Error {%s}", request.toString(), e.getMessage());
            LOGGER.error(e, errorMessage);
            if (e instanceof DatabricksSQLException) {
                throw new DatabricksHttpException(errorMessage, ((DatabricksSQLException)e).getSQLState());
            }
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
        StatementId statementId = new StatementId(response.getOperationHandle().operationId);
        LOGGER.debug(String.format("Executed statement in async for statementId [%s] in session [%s]", statementId.toSQLExecStatementId(), session.getSessionId()));
        DatabricksThreadContextHolder.setStatementId(statementId);
        if (parentStatement != null) {
            parentStatement.setStatementId(statementId);
        }
        StatementStatus statementStatus = DatabricksThriftUtil.getAsyncStatus(response.getStatus());
        return new DatabricksResultSet(statementStatus, statementId, null, statementType, parentStatement, session);
    }

    DatabricksResultSet getStatementResult(TOperationHandle operationHandle, IDatabricksStatementInternal parentStatement, IDatabricksSession session) throws SQLException {
        TGetOperationStatusResp response;
        LOGGER.debug("getStatementResult for StatementId {}", StatementId.loggableStatementId(operationHandle));
        long getStatementResultStartTime = System.nanoTime();
        StatementId statementId = new StatementId(operationHandle.getOperationId());
        String sessionInfo = session.getSessionId() + " (" + String.valueOf(session.getComputeResource()) + ")";
        TGetOperationStatusReq request = new TGetOperationStatusReq().setOperationHandle(operationHandle).setGetProgressUpdate(false);
        TFetchResultsResp resultSet = null;
        try {
            response = this.getOperationStatus(request, statementId);
            TOperationState operationState = response.getOperationState();
            if (operationState == TOperationState.FINISHED_STATE) {
                long fetchStartTime = System.nanoTime();
                resultSet = this.getResultSetResp(response.getStatus(), operationHandle, "getStatementResult", -1, true);
                long fetchEndTime = System.nanoTime();
                long fetchLatencyNanos = fetchEndTime - fetchStartTime;
                long fetchLatencyMillis = fetchLatencyNanos / 1000000L;
                LOGGER.debug("Connection [" + this.connectionUuid + "] Statement [" + String.valueOf(statementId) + "] Session [" + sessionInfo + "] Thrift getStatementResult fetch latency: " + fetchLatencyMillis + "ms");
                long getStatementResultEndTime = System.nanoTime();
                long getStatementResultLatencyNanos = getStatementResultEndTime - getStatementResultStartTime;
                long getStatementResultLatencyMillis = getStatementResultLatencyNanos / 1000000L;
                LOGGER.debug("Connection [" + this.connectionUuid + "] Statement [" + String.valueOf(statementId) + "] Session [" + sessionInfo + "] Thrift getStatementResult latency: " + getStatementResultLatencyMillis + "ms");
                return new DatabricksResultSet(new StatementStatus().setState(StatementState.SUCCEEDED), statementId, resultSet, StatementType.SQL, parentStatement, session);
            }
        }
        catch (TException e) {
            long getStatementResultEndTime = System.nanoTime();
            long getStatementResultLatencyNanos = getStatementResultEndTime - getStatementResultStartTime;
            long getStatementResultLatencyMillis = getStatementResultLatencyNanos / 1000000L;
            LOGGER.debug("Connection [" + this.connectionUuid + "] Statement [" + String.valueOf(statementId) + "] Session [" + sessionInfo + "] Thrift getStatementResult latency (with error): " + getStatementResultLatencyMillis + "ms");
            String errorMessage = String.format("Error while receiving response from Thrift server. Request {%s}, Error {%s}", request.toString(), e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
        StatementStatus executionStatus = DatabricksThriftUtil.getStatementStatus(response);
        long getStatementResultEndTime = System.nanoTime();
        long getStatementResultLatencyNanos = getStatementResultEndTime - getStatementResultStartTime;
        long getStatementResultLatencyMillis = getStatementResultLatencyNanos / 1000000L;
        LOGGER.debug("Connection [" + this.connectionUuid + "] Statement [" + String.valueOf(statementId) + "] Session [" + sessionInfo + "] Thrift getStatementResult latency: " + getStatementResultLatencyMillis + "ms");
        return new DatabricksResultSet(executionStatus, statementId, resultSet, StatementType.SQL, parentStatement, session);
    }

    DatabricksConfig getDatabricksConfig() {
        return this.databricksConfig;
    }

    void updateConfig(DatabricksConfig newConfig) {
        this.databricksConfig = newConfig;
    }

    TFetchResultsResp getResultSetResp(TStatus responseStatus, TOperationHandle operationHandle, String context, int maxRowsPerBlock, boolean fetchMetadata) throws DatabricksHttpException {
        TFetchResultsResp response;
        String statementId = StatementId.loggableStatementId(operationHandle);
        DatabricksThriftUtil.verifySuccessStatus(responseStatus, context, statementId);
        TFetchResultsReq request = new TFetchResultsReq().setOperationHandle(operationHandle).setFetchType((short)0).setMaxRows(maxRowsPerBlock).setMaxBytes(404857600L);
        if (fetchMetadata && ProtocolFeatureUtil.supportsResultSetMetadataFromFetch(this.serverProtocolVersion)) {
            request.setIncludeResultSetMetadata(true);
        }
        try {
            response = this.getThriftClient().FetchResults(request);
        }
        catch (TException e) {
            String errorMessage = String.format("Error while fetching results from Thrift server. Request maxRows=%d, maxBytes=%d, Error {%s}", request.getMaxRows(), request.getMaxBytes(), e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
        DatabricksThriftUtil.verifySuccessStatus(response.getStatus(), String.format("Error while fetching results Request maxRows=%d, maxBytes=%d. Response hasMoreRows=%s", request.getMaxRows(), request.getMaxBytes(), response.hasMoreRows), statementId);
        return response;
    }

    TFetchResultsResp fetchResultsWithAbsoluteOffset(TOperationHandle operationHandle, long startRowOffset, String context) throws DatabricksHttpException {
        TFetchResultsResp response;
        String statementId = StatementId.loggableStatementId(operationHandle);
        LOGGER.debug("Fetching results with FETCH_ABSOLUTE at offset {} for statement {}", startRowOffset, statementId);
        TFetchResultsReq request = new TFetchResultsReq().setOperationHandle(operationHandle).setStartRowOffset(startRowOffset).setFetchType((short)0).setMaxRows(this.maxRowsPerBlock).setMaxBytes(404857600L);
        try {
            response = this.getThriftClient().FetchResults(request);
        }
        catch (TException e) {
            String errorMessage = String.format("Error while fetching results from Thrift server with FETCH_ABSOLUTE. startRowOffset=%d, maxRows=%d, Error {%s}", startRowOffset, request.getMaxRows(), e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksHttpException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.INVALID_STATE);
        }
        DatabricksThriftUtil.verifySuccessStatus(response.getStatus(), String.format("Error while fetching results with FETCH_ABSOLUTE. startRowOffset=%d, hasMoreRows=%s", startRowOffset, response.hasMoreRows), statementId);
        return response;
    }

    private TFetchResultsResp listFunctions(TGetFunctionsReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetFunctionsResp response = this.getThriftClient().GetFunctions(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp listPrimaryKeys(TGetPrimaryKeysReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetPrimaryKeysResp response = this.getThriftClient().GetPrimaryKeys(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp listCrossReferences(TGetCrossReferenceReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetCrossReferenceResp response = this.getThriftClient().GetCrossReference(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp getTables(TGetTablesReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetTablesResp response = this.getThriftClient().GetTables(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp getTableTypes(TGetTableTypesReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetTableTypesResp response = this.getThriftClient().GetTableTypes(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp getCatalogs(TGetCatalogsReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetCatalogsResp response = this.getThriftClient().GetCatalogs(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp listSchemas(TGetSchemasReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetSchemasResp response = this.getThriftClient().GetSchemas(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp getTypeInfo(TGetTypeInfoReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetTypeInfoResp response = this.getThriftClient().GetTypeInfo(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    private TFetchResultsResp listColumns(TGetColumnsReq request) throws TException, SQLException {
        if (this.enableDirectResults) {
            request.setGetDirectResults(DEFAULT_DIRECT_RESULTS);
        }
        TGetColumnsResp response = this.getThriftClient().GetColumns(request);
        return this.fetchMetadataResults(response, response.toString());
    }

    TCLIService.Client getThriftClient() {
        if (DriverUtil.isRunningAgainstFake()) {
            return this.FAKE_SHARED_CLIENT.get();
        }
        return this.newThriftClient();
    }

    private TCLIService.Client newThriftClient() {
        DatabricksHttpTTransport transport = new DatabricksHttpTTransport(DatabricksHttpClientFactory.getInstance().getClient(this.connectionContext), this.endpointUrl, this.databricksConfig, this.connectionContext);
        return new TCLIService.Client(new TBinaryProtocol(transport));
    }

    private <TResp extends TBase<TResp, FResp>, FResp extends TFieldIdEnum> TFetchResultsResp fetchMetadataResults(TResp response, String contextDescription) throws TException, SQLException {
        String statementId;
        this.checkResponseForErrors(response);
        TGetOperationStatusResp statusResp = null;
        FResp directResultsField = response.fieldForId(directResultsFieldId);
        FResp operationHandleField = response.fieldForId(operationHandleFieldId);
        TOperationHandle operationHandle = response.isSet(operationHandleField) ? (TOperationHandle)response.getFieldValue(operationHandleField) : null;
        String string = statementId = operationHandle != null ? StatementId.loggableStatementId(operationHandle) : "null";
        if (response.isSet(directResultsField)) {
            TSparkDirectResults directResults = (TSparkDirectResults)response.getFieldValue(directResultsField);
            DatabricksThriftUtil.checkDirectResultsForErrorStatus(directResults, contextDescription, statementId);
            statusResp = directResults.getOperationStatus();
            this.checkOperationStatusForErrors(statusResp, statementId);
        }
        LOGGER.debug("Poll for operation status for statementId: {}", statementId);
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq().setOperationHandle(operationHandle).setGetProgressUpdate(false);
        while (this.shouldContinuePolling(statusResp)) {
            statusResp = this.getThriftClient().GetOperationStatus(statusReq);
            this.checkOperationStatusForErrors(statusResp, statementId);
        }
        if (this.hasResultDataInDirectResults(response)) {
            TSparkDirectResults directResults = (TSparkDirectResults)response.getFieldValue(directResultsField);
            return directResults.getResultSet();
        }
        FResp statusField = response.fieldForId(statusFieldId);
        TStatus status = (TStatus)response.getFieldValue(statusField);
        return this.getResultSetResp(status, operationHandle, contextDescription, 2000000, false);
    }

    private <T extends TBase<T, F>, F extends TFieldIdEnum> void checkResponseForErrors(TBase<T, F> response) throws DatabricksSQLException {
        F operationHandleField = response.fieldForId(operationHandleFieldId);
        F statusField = response.fieldForId(statusFieldId);
        TStatus status = (TStatus)response.getFieldValue(statusField);
        if (!response.isSet(operationHandleField) || this.isErrorStatusCode(status)) {
            LOGGER.error("Error thrift response {}", response);
            throw new DatabricksSQLException(status.getErrorMessage(), status.getSqlState());
        }
    }

    private void checkOperationStatusForErrors(TGetOperationStatusResp statusResp, String statementId) throws SQLException {
        if (statusResp != null && statusResp.isSetOperationState() && this.isErrorOperationState(statusResp.getOperationState())) {
            String errorMsg = String.format("Operation failed with error: [%s] for statement [%s], with response [%s]", statusResp.getErrorMessage(), statementId, statusResp);
            LOGGER.error(errorMsg);
            String sqlState = statusResp.getSqlState();
            if ("57KD0".equals(sqlState)) {
                throw new DatabricksTimeoutException(errorMsg, null, DatabricksDriverErrorCode.OPERATION_TIMEOUT_ERROR);
            }
            throw new DatabricksSQLException(errorMsg, sqlState);
        }
    }

    private boolean shouldContinuePolling(TGetOperationStatusResp statusResp) {
        return statusResp == null || !statusResp.isSetOperationState() || this.isPendingOperationState(statusResp.getOperationState());
    }

    private <T extends TBase<T, F>, F extends TFieldIdEnum> boolean hasResultDataInDirectResults(TBase<T, F> response) {
        F directResultsField = response.fieldForId(directResultsFieldId);
        if (!response.isSet(directResultsField)) {
            return false;
        }
        TSparkDirectResults directResults = (TSparkDirectResults)response.getFieldValue(directResultsField);
        return directResults.isSetResultSet() && directResults.isSetResultSetMetadata();
    }

    private boolean isErrorStatusCode(TStatus status) {
        if (status == null || !status.isSetStatusCode()) {
            LOGGER.error("Status code is not set, marking the response as failed");
            return true;
        }
        TStatusCode statusCode = status.getStatusCode();
        return statusCode == TStatusCode.ERROR_STATUS || statusCode == TStatusCode.INVALID_HANDLE_STATUS;
    }

    private boolean isErrorOperationState(TOperationState state) {
        return state == TOperationState.ERROR_STATE || state == TOperationState.CLOSED_STATE;
    }

    private boolean isPendingOperationState(TOperationState state) {
        return state == TOperationState.RUNNING_STATE || state == TOperationState.PENDING_STATE;
    }

    void setServerProtocolVersion(TProtocolVersion protocolVersion) {
        this.serverProtocolVersion = protocolVersion;
    }

    private TimeoutHandler getTimeoutHandler(TExecuteStatementResp response, int timeoutInSeconds, DatabricksDriverErrorCode internalErrorCode) {
        TOperationHandle operationHandle = response.getOperationHandle();
        return new TimeoutHandler(timeoutInSeconds, "Thrift Operation Handle: " + operationHandle.toString(), () -> {
            try {
                LOGGER.debug("Canceling operation due to timeout: {}", operationHandle);
                this.cancelOperation(new TCancelOperationReq().setOperationHandle(operationHandle));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to cancel operation on timeout: {}", e.getMessage());
            }
        }, internalErrorCode);
    }

    private TGetOperationStatusResp getOperationStatus(TGetOperationStatusReq statusReq, StatementId statementId) throws TException {
        long operationStatusStartTime = System.nanoTime();
        TGetOperationStatusResp operationStatus = this.getThriftClient().GetOperationStatus(statusReq);
        long operationStatusEndTime = System.nanoTime();
        long operationStatusLatencyMillis = (operationStatusEndTime - operationStatusStartTime) / 1000000L;
        LOGGER.debug("Statement [{}] Thrift operation status latency: {}ms", statementId, operationStatusLatencyMillis);
        TelemetryCollector.getInstance().recordGetOperationStatus(statementId.toSQLExecStatementId(), operationStatusLatencyMillis);
        return operationStatus;
    }
}

