(function(){
    "use strict";

    const searchNotebookInitModalDatasets = {
        bindings : {
            datasetScope: "<",
            connection: "<",
            cell: "<"
        },
        require: {
            apiErrorContext: "^apiErrorContext"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-init-modal-datasets/search-notebook-init-modal-datasets.component.html",
        controller: function($scope, DataikuAPI, MonoFuture, $stateParams, Logger, $filter) {
            const $ctrl = this;
            $ctrl.searchQuery = null;
            $ctrl.filteredDatasetsCount = 0;
            $ctrl.expandedDatasetsProjects = [];
            $ctrl.datasetsCount = null;
            $ctrl.filteredDatasets = [];
            $ctrl.allProjectsLoaded = false;

            $ctrl.$onChanges = () => {
                if (!$ctrl.datasetScope.datasets) {
                    loadDatasets(false);
                } else {
                    $ctrl.refreshDatasets($stateParams.projectKey, $ctrl.cell ? $ctrl.cell.searchScope.datasets : null, $ctrl.allProjectsLoaded);
                }
            };

            const filterDatasets = () => {
                if ($ctrl.searchQuery) { // filter query
                    const parents = [];
                    for (const originalNode of $ctrl.datasetScope.datasets) {
                        const parent = {...originalNode};
                        parent.children = parent.children.filter(i => i.data[0].toLowerCase().includes($ctrl.searchQuery));
                        if (parent.children.length > 0) { // Skip empty parents
                            parents.push(parent);
                        }
                    }
                    return parents;
                } else {
                    return $ctrl.datasetScope.datasets;
                }
            }

            const expandProjects = (openedProject) => {
                if (openedProject) {
                    $ctrl.expandedDatasetsProjects = $ctrl.filteredDatasets.filter(n => n.title === openedProject);
                    return;
                }

                const filtered = [];
                for (const expanded of $ctrl.expandedDatasetsProjects) {
                    const inQuery = $ctrl.filteredDatasets.filter(n => n.title === expanded.title);
                    if (inQuery.length > 0) {
                        filtered.push(inQuery[0]);
                    }
                }
                $ctrl.expandedDatasetsProjects = filtered;
            };

            $ctrl.refreshDatasets = (openedProject, preSelectedDatasets, allLoaded) => {
                if (!$ctrl.datasetScope.datasets) {
                    return;
                }

                // filter on preselect datasets
                let selectedDatasets = [];
                if (!allLoaded && preSelectedDatasets && preSelectedDatasets.length > 0) {
                    for (const originalNode of $ctrl.datasetScope.datasets) {
                        selectedDatasets = selectedDatasets.concat(originalNode.children.filter(i => preSelectedDatasets.includes(i.$dataset.smartName)));
                    }
                    $ctrl.datasetScope.selectedDatasets = selectedDatasets;
                } else if (allLoaded && $ctrl.datasetScope.selectedDatasets.length > 0) {
                    for (const originalNode of $ctrl.datasetScope.datasets) {
                        for (const selectedDataset of $ctrl.datasetScope.selectedDatasets) {
                            selectedDatasets = selectedDatasets.concat(originalNode.children.filter(i => selectedDataset.$dataset.smartName === i.$dataset.smartName));
                        }
                    }
                    $ctrl.datasetScope.selectedDatasets = selectedDatasets;
                }

                const parents = filterDatasets();

                // update displayed count
                let filteredDatasetsCount = 0;
                for (const parent of parents) {
                    filteredDatasetsCount += parent.children.length;
                }

                $ctrl.filteredDatasetsCount = filteredDatasetsCount;
                $ctrl.filteredDatasets = parents;
                // expand parent on selected project
                expandProjects(openedProject);
            };

            const loadDatasets = (loadAll) => {
                const endPoint = DataikuAPI.searchNotebooks.listUsableDatasets;
                const preSelectedDatasets = ($ctrl.cell && $ctrl.cell.searchScope.datasets || []);
                MonoFuture($ctrl).wrap(endPoint)($stateParams.projectKey, preSelectedDatasets, $ctrl.connection, loadAll).success((data) => {
                    const datasetsByproject = {};

                    for (const dataset of data.result) {
                        if (!datasetsByproject[dataset.projectKey]) {
                            datasetsByproject[dataset.projectKey] = {type: "parent", title: dataset.projectKey, children: []};
                        }
                        const hasCustomQueryDSL = dataset.params.customQueryDsl != null && dataset.params.customQueryDsl.trim().length > 0;
                        const modificationDate = $filter("friendlyDateTime")(new Date(dataset.versionTag.lastModifiedOn));
                        const data = [dataset.name, dataset.managed ? "Managed" : "External", modificationDate, hasCustomQueryDSL ? "Custom DSL will be ignored" : ""];
                        if (dataset.params.connection !== $ctrl.connection) {
                            Logger.warn(`dataset ${dataset.name} is on connection ${dataset.params.connection} while notebook is on ${ctrl.connection}. Skipping from list`);
                        }
                        datasetsByproject[dataset.projectKey].children.push({ type: "leaf", data: data, $dataset: dataset});
                    }

                    // Sort alphabetically by projectKey
                    const orderedDatasetsByproject = Object.keys(datasetsByproject).sort().reduce(
                        (obj, key) => {
                            obj[key] = datasetsByproject[key];
                            return obj;
                        },
                        {}
                    );

                    $ctrl.datasetsCount = data.result.length;
                    $ctrl.datasetScope.datasets = Object.values(orderedDatasetsByproject);
                    $ctrl.refreshDatasets($stateParams.projectKey, $ctrl.cell ? $ctrl.cell.searchScope.datasets : null, loadAll);
                })
                .error($ctrl.apiErrorContext.setError);
            };

            $ctrl.loadAllProjects = () => {
                $ctrl.allProjectsLoaded = true;
                loadDatasets(true);
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookInitModalDatasets", searchNotebookInitModalDatasets);
})();