(function() {
    "use strict";

    /**
     * <drawer-controls/>
     */
    const drawerControls = {
        templateUrl: "/static/dataiku/widgets/topbar-drawers/drawer-controls/drawer-controls.component.html",
        bindings: {
            drawer: '<',
        },
        controller: function drawerControlsController(TOPBAR_DRAWER_DOCKED_STATES, TOPBAR_DRAWER_MINIMIZED_STATES) {
            const ctrl = this;

            ctrl.$onInit = function() {
            };

            ctrl.DOCKED_STATES = TOPBAR_DRAWER_DOCKED_STATES;
            ctrl.MINIMIZED_STATES = TOPBAR_DRAWER_MINIMIZED_STATES;

            ctrl.getNextDrawerDockedState = function() {
                return ctrl.drawer.getActualDockedState() === TOPBAR_DRAWER_DOCKED_STATES.RIGHT
                    ? TOPBAR_DRAWER_DOCKED_STATES.LEFT
                    : TOPBAR_DRAWER_DOCKED_STATES.RIGHT;
            };

            ctrl.getNextDrawerMinimizedState = function() {
                return ctrl.drawer.getMinimizedState() === TOPBAR_DRAWER_MINIMIZED_STATES.NONE
                    ? TOPBAR_DRAWER_MINIMIZED_STATES.MINIMIZED
                    : TOPBAR_DRAWER_MINIMIZED_STATES.NONE;
            };

            ctrl.onHideButtonInit = function(elem) {
                // Focus the Close button the first time the drawer is open
                elem.find(".drawer-button").focus();
            };
        }
    };

    angular.module("dataiku.widgets").component("drawerControls", drawerControls);
})();
