from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....agents.tools.vectorstore.vector_store_query_tool.vector_store_query_tool_params import VectorStoreQueryToolParams, _VectorStoreQueryToolParams
    from ....dataflow.exec.filter.filter_desc.filter_desc import FilterDesc, _FilterDesc
    from ..ragllm_settings.ragllm_settings import RAGLLMSettings, _RAGLLMSettings
    from .augmentation_fallback_strategy import AugmentationFallbackStrategy
    from .column_description import ColumnDescription, _ColumnDescription
    from .rag_reranking_settings import RAGRerankingSettings, _RAGRerankingSettings
    from .search_type import SearchType
    from .sources_settings import SourcesSettings, _SourcesSettings

'''
Translated from class com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings
Via: PyModel annotation in the class hierarchy
'''


class _BaseVectorStoreQuerySettings(TypedDict):
    allowAgentInferredFiltering: bool
    allowDynamicFiltering: bool
    allowEmptyQuery: bool
    augmentationFallbackStrategy: 'AugmentationFallbackStrategy'
    columnsDescriptions: List['ColumnDescription']
    enforceDocumentLevelSecurity: bool
    filter: 'FilterDesc'
    includeScore: bool
    maxDocuments: int
    mmrDiversity: float
    mmrK: int
    performFiltering: bool
    reranking: 'RAGRerankingSettings'
    retrievalColumns: NotRequired[Optional[List[str]]]
    rrfRankConstant: int
    rrfRankWindowSize: int
    searchType: 'SearchType'
    similarityThreshold: float
    sourcesSettings: 'SourcesSettings'
    useAdvancedReranking: bool


# List of all concrete subclasses of com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings
BaseVectorStoreQuerySettings = Union[
    'VectorStoreQueryToolParams',
    'RAGLLMSettings',
]


# EOF
