# Python<->Java mapping
from typing import TypeVar
from typing import Union

from dataiku.generated_sources._typing import TypedDict

class SingleCommandWithId(TypedDict):
    id: str  # manually set on the python-side to track the request in the logs


from dataiku.generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.device_strategy import DeviceStrategy
from dataiku.generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.inference_settings import InferenceSettings as ModelSettings
from dataiku.generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.tool_settings import ToolSettings
from dataiku.generated_sources.com.dataiku.dip.connections.hugging_face_local_connection.chat_template_settings import ChatTemplateSettings
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand as ProcessSinglePromptCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand as ProcessSingleEmbeddingCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_reranking_command.process_single_reranking_command import ProcessSingleRerankingCommand as ProcessSingleRerankingCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.stream_response_chunk_or_footer.stream_response_chunk_or_footer import StreamResponseChunkOrFooter
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.hugging_face_kernel_command import HuggingFaceKernelCommand as HuggingFaceKernelCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.start_command import StartCommand
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.collect_tracking_data import CollectTrackingData
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.collect_tracking_data_response import CollectTrackingDataResponse
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.python_server_command.python_server_command import PythonServerCommand as ProcessSingleCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.io.commands.process_single_image_generation_command.process_single_image_generation_command import ProcessSingleImageGenerationCommand as ProcessSingleImageGenerationCommandModel
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.image_generation_kernel_response import ImageGenerationKernelResponse as ProcessSingleImageGenerationResponse
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.zero_shot_classification_response import ZeroShotClassificationResponse
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.process_single_prompt_response import ProcessSinglePromptResponse as ProcessSinglePromptResponseFull
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.simple_embedding_response import SimpleEmbeddingResponse as ProcessSingleEmbeddingResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.single_reranking_response import SingleRerankingResponse as ProcessSingleRerankingResponse
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.single_completion_query import SingleCompletionQuery
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.completion_settings import CompletionSettings
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.detailed_log_prob import DetailedLogProb
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.chat_message import ChatMessage
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.chat_message_part import ChatMessagePart
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_query import EmbeddingQuery
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.embedding_settings import EmbeddingSettings
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_chunk import StreamedCompletionResponseChunk
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.streamed_completion_response_footer import StreamedCompletionResponseFooter
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.tool_choice import ToolChoice
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.function_tool_call import FunctionToolCall
from dataiku.generated_sources.com.dataiku.dip.llm.local.hugging_face_kernel_client.usage_data import UsageData
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.finish_reason import FinishReason
from dataiku.generated_sources.com.dataiku.dip.llm.online.llm_client.artifact import Artifact

class ProcessSinglePromptCommand(ProcessSinglePromptCommandModel, SingleCommandWithId):
    pass


class ProcessSingleEmbeddingCommand(ProcessSingleEmbeddingCommandModel, SingleCommandWithId):
    pass


class ProcessSingleImageGenerationCommand(ProcessSingleImageGenerationCommandModel, SingleCommandWithId):
    pass

class ProcessSingleRerankingCommand(ProcessSingleRerankingCommandModel, SingleCommandWithId):
    pass


ProcessSingleCommand = Union[ProcessSinglePromptCommand, ProcessSingleEmbeddingCommand, ProcessSingleRerankingCommand, ProcessSingleImageGenerationCommand, ProcessSingleRerankingCommand]
SingleCommand = TypeVar("SingleCommand", bound=ProcessSingleCommand)

HuggingFaceKernelCommand = Union[ProcessSingleCommand, HuggingFaceKernelCommandModel]

class ProcessSinglePromptResponseTextFull(ProcessSinglePromptResponseFull):
    text: str  # type: ignore


class ProcessSinglePromptResponseZeroShotClassification(ProcessSinglePromptResponseFull):
    classification: ZeroShotClassificationResponse  # type: ignore


ProcessSinglePromptResponseText = Union[ProcessSinglePromptResponseTextFull, StreamResponseChunkOrFooter]
ProcessSinglePromptResponse = Union[ProcessSinglePromptResponseText, ProcessSinglePromptResponseZeroShotClassification]
ProcessSingleResponse = Union[ProcessSinglePromptResponse, ProcessSingleEmbeddingResponse, ProcessSingleRerankingResponse, ProcessSingleImageGenerationResponse, CollectTrackingDataResponse]
SingleResponse = TypeVar("SingleResponse", bound=ProcessSingleResponse)
