#!/bin/bash -e

# Displays OS dependent info regarding compat with 
# various TLS settings

MYDIR=$(cd "$(dirname "$0")" && pwd -P)
DKUINSTALLDIR=$(dirname "$MYDIR")

TLS_CIPHERS=$("$DKUPYTHONBIN" "$DKUINSTALLDIR"/scripts/dkuinstall/install_config.py -get server ssl_ciphers)

detectedDistrib=$("$MYDIR"/_find-distrib.sh 2>/dev/null || echo "unknown unknown")
read distrib distribVersion <<< "$detectedDistrib"

print_tls13only_unsupported_warning() {
  echo "[-] WARNING: the mode ssl_ciphers=tls13only is not supported on $distrib $distribVersion."
}

if [[ "$TLS_CIPHERS" == "tls13only" ]]; then
  case "$distrib" in
      debian)
          case "$distribVersion" in
              11*) print_tls13only_unsupported_warning;;
          esac;;
      ubuntu)
          case "$distribVersion" in
              "20.04") print_tls13only_unsupported_warning;;
              "22.04") print_tls13only_unsupported_warning;;
          esac;;
      centos | redhat | oraclelinux | almalinux | rocky)
          case "$distribVersion" in
              8*) print_tls13only_unsupported_warning;;
          esac;;
      amazonlinux)
        ;;
      suse)
        ;;
      osx)
        ;;
      *) print_tls13only_unsupported_warning;;
  esac
fi
