from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .probability_density_function import ProbabilityDensityFunction, _ProbabilityDensityFunction
    from .probability_mass_function import ProbabilityMassFunction, _ProbabilityMassFunction
    from .qq_plot_data import QQPlotData, _QQPlotData
from ......utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.computations.univariate.TestDistribution$PlotData
Via: com.dataiku.dip.eda.compute.computations.univariate.TestDistribution$TestDistributionResult
'''


class _PlotData(_ImmutableValueObject, TypedDict):
    pdf: NotRequired[Optional['ProbabilityDensityFunction']]
    pmf: NotRequired[Optional['ProbabilityMassFunction']]
    qq: 'QQPlotData'


PlotData = _PlotData


# EOF
