from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan
    from .reranked_document import RerankedDocument, _RerankedDocument
    from .single_reranking_response_or_error import SingleRerankingResponseOrError, _SingleRerankingResponseOrError
    from .total_usage import TotalUsage, _TotalUsage

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$SingleRerankingResponse
Via: PyModel annotation in the class hierarchy
'''


class _SingleRerankingResponse(TypedDict):
    documents: List['RerankedDocument']
    estimatedCost: float
    fromCache: bool
    totalUsage: 'TotalUsage'
    trace: 'LLMMeshTraceSpan'


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$SingleRerankingResponse
SingleRerankingResponse = Union[
    '_SingleRerankingResponse',
    'SingleRerankingResponseOrError',
]


# EOF
