from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..unit_root_test_adf.unit_root_test_adf import UnitRootTestADF, _UnitRootTestADF
    from ..unit_root_test_kpss.unit_root_test_kpss import UnitRootTestKPSS, _UnitRootTestKPSS
    from ..unit_root_test_za.unit_root_test_za import UnitRootTestZA, _UnitRootTestZA
from ..time_series_computation.time_series_computation import TimeSeriesComputation, _TimeSeriesComputation

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest
Via: PyModel annotation in the class hierarchy
'''


class _UnitRootTest(_TimeSeriesComputation, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest
UnitRootTest = Union[
    'UnitRootTestADF',
    'UnitRootTestKPSS',
    'UnitRootTestZA',
]

# Types of class com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest in PolyJSON mappings (as literal type)
UnitRootTestTypeLiteral = Literal["unit_root_adf", "unit_root_kpss", "unit_root_za", ]


# EOF
