from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .function_tool_call import FunctionToolCall, _FunctionToolCall

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$AbstractToolCall
Via: com.dataiku.dip.llm.local.HuggingFaceKernelClient$ProcessSinglePromptResponse
'''


class _AbstractToolCall(TypedDict):
    id: NotRequired[Optional[str]]
    index: NotRequired[Optional[int]]
    llmReasoning: NotRequired[Optional[Dict[str, Any]]]


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$AbstractToolCall
AbstractToolCall = Union['FunctionToolCall']

# Types of class com.dataiku.dip.llm.online.LLMClient$AbstractToolCall in PolyJSON mappings (as literal type)
AbstractToolCallTypeLiteral = Literal["function", ]


# EOF
