from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .file_ref import FileRef, _FileRef
    from .image_ref import ImageRef, _ImageRef
    from .source_records import SourceRecords, _SourceRecords

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$SourceItem
Via: PyModel annotation in the class hierarchy
'''


class _SourceItem(TypedDict):
    customData: Dict[str, Any]
    dataBase64: str
    fileRef: 'FileRef'
    filename: str
    htmlSnippet: str
    imageRefs: List['ImageRef']
    index: int
    jsonSnippet: str
    markdownSnippet: str
    metadata: Dict[str, Any]
    mimeType: str
    performedQuery: str
    records: 'SourceRecords'
    text: str
    textSnippet: str
    thumbnailH: int
    thumbnailInlineB64: str
    thumbnailURL: str
    thumbnailW: int
    title: str
    type: str
    url: str


SourceItem = _SourceItem


# EOF
