from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .abstract_tool_call import AbstractToolCall, _AbstractToolCall
    from .artifact import Artifact, _Artifact
    from .detailed_log_prob import DetailedLogProb, _DetailedLogProb
    from .memory_fragment import MemoryFragment, _MemoryFragment
    from .tool_validation_request import ToolValidationRequest, _ToolValidationRequest

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$StreamedCompletionResponseChunk
Via: com.dataiku.dip.llm.io.commands.StreamResponseChunkOrFooter
'''


class _StreamedCompletionResponseChunk(TypedDict):
    artifacts: NotRequired[Optional[List['Artifact']]]
    eventData: NotRequired[Optional[Dict[str, Any]]]
    eventKind: NotRequired[Optional[str]]
    logProbs: NotRequired[Optional[List['DetailedLogProb']]]
    memoryFragment: NotRequired[Optional['MemoryFragment']]
    text: NotRequired[Optional[str]]
    toolCalls: NotRequired[Optional[List['AbstractToolCall']]]
    toolValidationRequests: NotRequired[Optional[List['ToolValidationRequest']]]
    type: str


StreamedCompletionResponseChunk = _StreamedCompletionResponseChunk


# EOF
