/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.status.LocalSparkJobMonitor;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.exec.spark.status.impl.LocalSparkJobStatus;
import org.apache.spark.api.java.JavaSparkContext;

public class LocalSparkJobRef
implements SparkJobRef {
    private final String jobId;
    private final HiveConf hiveConf;
    private final LocalSparkJobStatus sparkJobStatus;
    private final JavaSparkContext javaSparkContext;

    public LocalSparkJobRef(String jobId, HiveConf hiveConf, LocalSparkJobStatus sparkJobStatus, JavaSparkContext javaSparkContext) {
        this.jobId = jobId;
        this.hiveConf = hiveConf;
        this.sparkJobStatus = sparkJobStatus;
        this.javaSparkContext = javaSparkContext;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public SparkJobStatus getSparkJobStatus() {
        return this.sparkJobStatus;
    }

    @Override
    public boolean cancelJob() {
        int id = Integer.parseInt(this.jobId);
        this.javaSparkContext.sc().cancelJob(id);
        return true;
    }

    @Override
    public int monitorJob() {
        LocalSparkJobMonitor localSparkJobMonitor = new LocalSparkJobMonitor(this.hiveConf, this.sparkJobStatus);
        return localSparkJobMonitor.startMonitor();
    }
}

