/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.monitoring.v3;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.resourcenames.ResourceName;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MonitoredResourceDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String monitoredResourceDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getMonitoredResourceDescriptor() {
        return this.monitoredResourceDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MonitoredResourceDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.monitoredResourceDescriptor = Preconditions.checkNotNull(builder.getMonitoredResourceDescriptor());
    }

    public static MonitoredResourceDescriptorName of(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    public static String format(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    public static MonitoredResourceDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MonitoredResourceDescriptorName.parse: formattedString not in valid format");
        return MonitoredResourceDescriptorName.of(matchMap.get("project"), matchMap.get("monitored_resource_descriptor"));
    }

    public static List<MonitoredResourceDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<MonitoredResourceDescriptorName> list = new ArrayList<MonitoredResourceDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MonitoredResourceDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MonitoredResourceDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MonitoredResourceDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MonitoredResourceDescriptorName monitoredResourceDescriptorName = this;
            synchronized (monitoredResourceDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("monitoredResourceDescriptor", this.monitoredResourceDescriptor);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "monitored_resource_descriptor", this.monitoredResourceDescriptor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MonitoredResourceDescriptorName) {
            MonitoredResourceDescriptorName that = (MonitoredResourceDescriptorName)o;
            return this.project.equals(that.project) && this.monitoredResourceDescriptor.equals(that.monitoredResourceDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.monitoredResourceDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String monitoredResourceDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(MonitoredResourceDescriptorName monitoredResourceDescriptorName) {
            this.project = monitoredResourceDescriptorName.project;
            this.monitoredResourceDescriptor = monitoredResourceDescriptorName.monitoredResourceDescriptor;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }
}

