/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.statistics;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.Preconditions;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import shaded.parquet.it.unimi.dsi.fastutil.longs.LongArrayList;

public class SizeStatistics {
    private final PrimitiveType type;
    private long unencodedByteArrayDataBytes;
    private final List<Long> repetitionLevelHistogram;
    private final List<Long> definitionLevelHistogram;
    private boolean valid = true;

    public static Builder newBuilder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
        return new Builder(type, maxRepetitionLevel, maxDefinitionLevel);
    }

    public SizeStatistics(PrimitiveType type, long unencodedByteArrayDataBytes, List<Long> repetitionLevelHistogram, List<Long> definitionLevelHistogram) {
        this.type = type;
        this.unencodedByteArrayDataBytes = unencodedByteArrayDataBytes;
        this.repetitionLevelHistogram = repetitionLevelHistogram == null ? Collections.emptyList() : repetitionLevelHistogram;
        this.definitionLevelHistogram = definitionLevelHistogram == null ? Collections.emptyList() : definitionLevelHistogram;
    }

    public void mergeStatistics(SizeStatistics other) {
        int i;
        if (!this.valid) {
            return;
        }
        if (other == null || !other.isValid()) {
            this.valid = false;
            this.unencodedByteArrayDataBytes = 0L;
            this.repetitionLevelHistogram.clear();
            this.definitionLevelHistogram.clear();
            return;
        }
        Preconditions.checkArgument(this.type.equals((Object)other.type), "Cannot merge SizeStatistics of different types");
        this.unencodedByteArrayDataBytes = Math.addExact(this.unencodedByteArrayDataBytes, other.unencodedByteArrayDataBytes);
        if (other.repetitionLevelHistogram.isEmpty()) {
            this.repetitionLevelHistogram.clear();
        } else {
            Preconditions.checkArgument(this.repetitionLevelHistogram.size() == other.repetitionLevelHistogram.size(), "Cannot merge SizeStatistics with different repetition level histogram size");
            for (i = 0; i < this.repetitionLevelHistogram.size(); ++i) {
                this.repetitionLevelHistogram.set(i, Math.addExact(this.repetitionLevelHistogram.get(i), other.repetitionLevelHistogram.get(i)));
            }
        }
        if (other.definitionLevelHistogram.isEmpty()) {
            this.definitionLevelHistogram.clear();
        } else {
            Preconditions.checkArgument(this.definitionLevelHistogram.size() == other.definitionLevelHistogram.size(), "Cannot merge SizeStatistics with different definition level histogram size");
            for (i = 0; i < this.definitionLevelHistogram.size(); ++i) {
                this.definitionLevelHistogram.set(i, Math.addExact(this.definitionLevelHistogram.get(i), other.definitionLevelHistogram.get(i)));
            }
        }
    }

    public PrimitiveType getType() {
        return this.type;
    }

    public Optional<Long> getUnencodedByteArrayDataBytes() {
        if (this.type.getPrimitiveTypeName() != PrimitiveType.PrimitiveTypeName.BINARY) {
            return Optional.empty();
        }
        return Optional.of(this.unencodedByteArrayDataBytes);
    }

    public List<Long> getRepetitionLevelHistogram() {
        return Collections.unmodifiableList(this.repetitionLevelHistogram);
    }

    public List<Long> getDefinitionLevelHistogram() {
        return Collections.unmodifiableList(this.definitionLevelHistogram);
    }

    public SizeStatistics copy() {
        return new SizeStatistics(this.type, this.unencodedByteArrayDataBytes, new LongArrayList(this.repetitionLevelHistogram), new LongArrayList(this.definitionLevelHistogram));
    }

    public boolean isValid() {
        return this.valid;
    }

    public static Builder noopBuilder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
        return new NoopBuilder(type, maxRepetitionLevel, maxDefinitionLevel);
    }

    private static class NoopBuilder
    extends Builder {
        private NoopBuilder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
            super(type, maxRepetitionLevel, maxDefinitionLevel);
        }

        @Override
        public void add(int repetitionLevel, int definitionLevel) {
        }

        @Override
        public void add(int repetitionLevel, int definitionLevel, Binary value) {
        }

        @Override
        public SizeStatistics build() {
            SizeStatistics stats = new SizeStatistics(this.type, 0L, Collections.emptyList(), Collections.emptyList());
            stats.valid = false;
            return stats;
        }
    }

    public static class Builder {
        protected final PrimitiveType type;
        private long unencodedByteArrayDataBytes;
        private final long[] repetitionLevelHistogram;
        private final long[] definitionLevelHistogram;

        private Builder(PrimitiveType type, int maxRepetitionLevel, int maxDefinitionLevel) {
            this.type = type;
            this.unencodedByteArrayDataBytes = 0L;
            this.repetitionLevelHistogram = maxRepetitionLevel > 0 ? new long[maxRepetitionLevel + 1] : new long[0];
            this.definitionLevelHistogram = maxDefinitionLevel > 1 ? new long[maxDefinitionLevel + 1] : new long[0];
        }

        public void add(int repetitionLevel, int definitionLevel) {
            if (this.repetitionLevelHistogram.length > 0) {
                int n = repetitionLevel;
                this.repetitionLevelHistogram[n] = this.repetitionLevelHistogram[n] + 1L;
            }
            if (this.definitionLevelHistogram.length > 0) {
                int n = definitionLevel;
                this.definitionLevelHistogram[n] = this.definitionLevelHistogram[n] + 1L;
            }
        }

        public void add(int repetitionLevel, int definitionLevel, Binary value) {
            this.add(repetitionLevel, definitionLevel);
            if (this.type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY && value != null) {
                this.unencodedByteArrayDataBytes += (long)value.length();
            }
        }

        public SizeStatistics build() {
            return new SizeStatistics(this.type, this.unencodedByteArrayDataBytes, new LongArrayList(this.repetitionLevelHistogram), new LongArrayList(this.definitionLevelHistogram));
        }
    }
}

