/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.DataQualityMetricValues;
import com.amazonaws.services.glue.model.transform.MetricBasedObservationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MetricBasedObservation
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private DataQualityMetricValues metricValues;
    private List<String> newRules;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricBasedObservation withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setMetricValues(DataQualityMetricValues metricValues) {
        this.metricValues = metricValues;
    }

    public DataQualityMetricValues getMetricValues() {
        return this.metricValues;
    }

    public MetricBasedObservation withMetricValues(DataQualityMetricValues metricValues) {
        this.setMetricValues(metricValues);
        return this;
    }

    public List<String> getNewRules() {
        return this.newRules;
    }

    public void setNewRules(Collection<String> newRules) {
        if (newRules == null) {
            this.newRules = null;
            return;
        }
        this.newRules = new ArrayList<String>(newRules);
    }

    public MetricBasedObservation withNewRules(String ... newRules) {
        if (this.newRules == null) {
            this.setNewRules(new ArrayList<String>(newRules.length));
        }
        for (String ele : newRules) {
            this.newRules.add(ele);
        }
        return this;
    }

    public MetricBasedObservation withNewRules(Collection<String> newRules) {
        this.setNewRules(newRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getMetricValues() != null) {
            sb.append("MetricValues: ").append(this.getMetricValues()).append(",");
        }
        if (this.getNewRules() != null) {
            sb.append("NewRules: ").append(this.getNewRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricBasedObservation)) {
            return false;
        }
        MetricBasedObservation other = (MetricBasedObservation)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getMetricValues() == null ^ this.getMetricValues() == null) {
            return false;
        }
        if (other.getMetricValues() != null && !other.getMetricValues().equals(this.getMetricValues())) {
            return false;
        }
        if (other.getNewRules() == null ^ this.getNewRules() == null) {
            return false;
        }
        return other.getNewRules() == null || other.getNewRules().equals(this.getNewRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricValues() == null ? 0 : this.getMetricValues().hashCode());
        hashCode = 31 * hashCode + (this.getNewRules() == null ? 0 : this.getNewRules().hashCode());
        return hashCode;
    }

    public MetricBasedObservation clone() {
        try {
            return (MetricBasedObservation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricBasedObservationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

