/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.SnowflakeNodeData;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class SnowflakeNodeDataMarshaller {
    private static final MarshallingInfo<String> SOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceType").build();
    private static final MarshallingInfo<StructuredPojo> CONNECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Connection").build();
    private static final MarshallingInfo<String> SCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Schema").build();
    private static final MarshallingInfo<String> TABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Table").build();
    private static final MarshallingInfo<String> DATABASE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Database").build();
    private static final MarshallingInfo<String> TEMPDIR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TempDir").build();
    private static final MarshallingInfo<StructuredPojo> IAMROLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRole").build();
    private static final MarshallingInfo<Map> ADDITIONALOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdditionalOptions").build();
    private static final MarshallingInfo<String> SAMPLEQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SampleQuery").build();
    private static final MarshallingInfo<String> PREACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreAction").build();
    private static final MarshallingInfo<String> POSTACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PostAction").build();
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Action").build();
    private static final MarshallingInfo<Boolean> UPSERT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Upsert").build();
    private static final MarshallingInfo<String> MERGEACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MergeAction").build();
    private static final MarshallingInfo<String> MERGEWHENMATCHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MergeWhenMatched").build();
    private static final MarshallingInfo<String> MERGEWHENNOTMATCHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MergeWhenNotMatched").build();
    private static final MarshallingInfo<String> MERGECLAUSE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MergeClause").build();
    private static final MarshallingInfo<String> STAGINGTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StagingTable").build();
    private static final MarshallingInfo<List> SELECTEDCOLUMNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SelectedColumns").build();
    private static final MarshallingInfo<Boolean> AUTOPUSHDOWN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutoPushdown").build();
    private static final MarshallingInfo<List> TABLESCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableSchema").build();
    private static final SnowflakeNodeDataMarshaller instance = new SnowflakeNodeDataMarshaller();

    public static SnowflakeNodeDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(SnowflakeNodeData snowflakeNodeData, ProtocolMarshaller protocolMarshaller) {
        if (snowflakeNodeData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)snowflakeNodeData.getSourceType(), SOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getConnection(), CONNECTION_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getSchema(), SCHEMA_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getTable(), TABLE_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getDatabase(), DATABASE_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getTempDir(), TEMPDIR_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getIamRole(), IAMROLE_BINDING);
            protocolMarshaller.marshall(snowflakeNodeData.getAdditionalOptions(), ADDITIONALOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getSampleQuery(), SAMPLEQUERY_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getPreAction(), PREACTION_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getPostAction(), POSTACTION_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getUpsert(), UPSERT_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getMergeAction(), MERGEACTION_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getMergeWhenMatched(), MERGEWHENMATCHED_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getMergeWhenNotMatched(), MERGEWHENNOTMATCHED_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getMergeClause(), MERGECLAUSE_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getStagingTable(), STAGINGTABLE_BINDING);
            protocolMarshaller.marshall(snowflakeNodeData.getSelectedColumns(), SELECTEDCOLUMNS_BINDING);
            protocolMarshaller.marshall((Object)snowflakeNodeData.getAutoPushdown(), AUTOPUSHDOWN_BINDING);
            protocolMarshaller.marshall(snowflakeNodeData.getTableSchema(), TABLESCHEMA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

